/*
 * series slot of Im - computes series(Im(f), x, n, dir)
 *
 * dir <> Undirected or is(x, Type::Real) --> map(series(s, x, n, dir), Im)
 * otherwise returns unevaluatedly
 */

Im::series := proc(f, x, n, dir)
  local t;
begin 
  if dir = Undirected and is(x, Type::Real) <> TRUE then
    // no undirected expansion
    return(FAIL)
  end_if;

  // expand the argument
  t := Series::series(f, x, n, dir);

  if domtype(t) <> Series::Puiseux then
    FAIL
  else
    Series::Puiseux::map(t, Im)
  end_if
end_proc:
