/*
 * series slot of Re - computes series(Re(f), x, n, dir)
 *
 * dir <> Undirected or is(x, Type::Real) --> map(series(s, x, n, dir), Re)
 * otherwise returns unevaluatedly
 */

Re::series := proc(f, x, n, dir, opt)
  local t;
begin 
  if dir = Undirected and is(x, Type::Real) <> TRUE then
    // no undirected expansion
    return(FAIL)
  end_if;

  // expand the argument
  t := Series::series(f, x, n, dir, opt);

  if domtype(t) <> Series::Puiseux then
    FAIL
  else
    Series::Puiseux::map(t, Re)
  end_if
end_proc:
