
// handles the call series(arctanh(f), x, n, dir)

arctanh::series := proc(f, x, n, dir, opt)
   local s, l, t, d, a, w;
begin

   if dir <> Undirected then // directional expansion
     l:= limit(f,x,dir);
     if has(l, hold(limit)) or l = undefined then
       return(FAIL)
     elif iszero(l) or has(l, infinity) then
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;      
       // s := series(arctanh(x), x, n);
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2) + 1,s,x,0,dir);
       if f=x then
         return(s)
       elif iszero(l) then
           return(Series::Puiseux::_fconcat(s,Series::series(f,x,n,dir, opt)))
       elif has(l, infinity) then
           // arctanh(x) = signIm(x)*I*PI/2 + arctanh(1/x)
           s := Series::Puiseux::_fconcat(s, Series::series(1/f, x, n, dir, opt));
           w := sign(l);
           if numeric::isnonzero(Im(w)) = TRUE then
             // shortcut; we are approaching complexInfinity along a line
             // not parallel to the real axis ==> signIm(f) = signIm(w)
             return(Series::Puiseux::const(signIm(w)*I*PI/2, x,
                                           Series::Puiseux::order(s)) + s)
           else
             return(Series::Puiseux::const(signIm(f)*I*PI/2, x,
                                           Series::Puiseux::order(s)) + s)
           end_if
       end_if
     end_if
   end_if;

   // recursively expand the argument
   t := Series::series(f, x, n, dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d=FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     end_if;
     if d > 0 then // expansion around 0
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2)+1,s,x,0,dir);
       if f=x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if
     elif d = 0 then
       // expansion around a finite point a <> 0
       a := lcoeff(t);
       if a = 1 then
         // branch point
         return(Series::series(-1/2*(ln((f*I - I)*I/2) - ln(1 - (I*f - I)*I/2)),
                               x, n, dir, opt))
       elif a = -1 then
         // branch point
         return(Series::series(1/2*(ln(-(I*f + I)*I/2) - ln(1 + (I*f + I)*I/2)),
                               x, n, dir, opt))
       elif is(a, Type::Real) = TRUE then
         s := Series::unknown(arctanh(f), x, n, dir);
         // expansion on the branch cut:
         // add correction term for the upper/lower half plane, respectively
         if is(a > 1) = TRUE then
           return(Series::Puiseux::const((signIm(f) + 1)*I*PI/2, x,
                                         Series::Puiseux::order(s), dir) + s)
         elif is(a < -1) = TRUE then
           return(Series::Puiseux::const(-(signIm(-f) + 1)*I*PI/2, x,
                                         Series::Puiseux::order(s), dir) + s)
         else
           return(s)
         end_if
       end_if
     else // d < 0, undirected expansion around complexInfinity
       // s := series(arctanh(x), x, n);
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;      
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2) + 1,s,x,0,dir);
       // arctanh(x) = signIm(x)*I*PI/2 + arctanh(1/x)
       s := Series::Puiseux::_fconcat(s, Series::series(1/f, x, n, dir, opt));
       return(Series::Puiseux::const(signIm(f)*I*PI/2, x,
                                     Series::Puiseux::order(s)) + s)
     end_if
   end_if;

   Series::unknown(arctanh(f),x,n,dir);

end_proc:
