/*--
        besselI/Series -- the function attribut "series" for besselI
--*/

besselI::series := proc(v,f,x,n,dir, opt)
   local fv,k,l,mu,s,sc,sw,P,x2,t,vabs,tt;
begin
   fv:=float(v):
   if not(type(fv)=DOM_FLOAT or type(fv)=DOM_COMPLEX) or has(v,x) then
      // i.e., proceed to Series::unknown below
   else
      // recursively expand the argument
      tt := Series::series(f, x, n, dir, opt);

      if dir <> Undirected then // directional expansion
        l:=limit(f,x,dir);
      elif domtype(tt) = Series::Puiseux then
        if ldegree(tt) = FAIL then // order too small
          l := FAIL;
        elif ldegree(tt) >= 0 then
          l := coeff(tt, x, 0);
        else
          return(FAIL)
        end_if
      else
        l := FAIL
      end_if;

      if iszero(l) then // expansion in 0: use definition 9.1.10 
         x2:=x^2;
         if iszero(v) then
            //Abramowitz and Stegun 9.6.12
            t:=1;
            s:=_plus(1,(t:=t*1/4*x2/k^2)$ k=1..trunc(n/2));
         else
            //Abramowitz and Stegun 9.6.10 combined with
            //reflection formula of 9.6.6
            // bug fix for negative indices
         if type(v)=DOM_INT then
          vabs:=abs(v);
         else
          vabs:=v;
         end_if;
            //vabs:=abs(v);
            s:=1/gamma(vabs+1):
            t:=s;
            s:=_plus(s,(t:=t*1/4*x2/k/(k+vabs))$ k=1..trunc(n/2));
            s:=(x^vabs/2^vabs)*s;
         end_if;
// More efficient: use create !!!
         s:=Series::series(s,x,n,dir, opt);
         if f=x then return(s) else return(s @ tt) end_if
      elif l=infinity or l=-infinity then

         // Abramowitz and Stegun 9.7.1
         // changed z into 1/x (z->infinity when x->0, Right) 
         // We keep in mind a reflection formula which applies
         // to the complex plane for "v" integer:
         // 1) I_(-v) (z) = I_(v) (z)  reflection formula    (9.6.6)
         //
         // For expansions about -infinity, we use the same phase 
         // factor "sw" as for the besselJ functions.
         // WARNING: expansion is only valid for the half-plane!
         if type(v)=DOM_INT then
          sc:=sign(l)^v;
         else
          sc:=1;
         end_if;
         mu:=4*v^2;
         t:=1;
//         P:=Series::series(_plus(1,(t:=-t*(mu-(2*k-1)^2)/k/8*x)$k=1..(n-1)),x,n):
// Puiseux::create is more efficient:
         P := [1, (t := -t*(mu - (2*k - 1)^2)/k/8) $ k = 1..(n - 1)];
         P := Series::Puiseux::create(1, 0, n, P, x, 0, dir);
         if sign(l) > 0 or domtype(v)=DOM_INT then
          if f <> 1/x and f <> -1/x then
            s:=Series::series(sign(l)/f,x,n,dir);
            P:=P @ s; 
          end_if:
          P := P * Series::series(sqrt(sign(l)/f), x, n, dir, opt);
          return(P::dom::scalmult(P, sc/2^(1/2)/PI^(1/2))
                 * Series::series(exp(sign(l)*f), x, n, dir, opt))
         else
          if f <> -1/x then
            s:=Series::series(sign(l)/f,x,n,dir, opt);
            P:=P @ s;
          end_if:
          P := P * Series::series(f^(-1/2), x, n, dir, opt);
          sw:= (-1)^((v+1/2)*signIm(f));
          return(P::dom::scalmult(P, sw/2^(1/2)/PI^(1/2))
                 * Series::series(exp(sign(l)*f), x, n, dir, opt))
         end_if: 
      end_if;

   end_if;

   Series::unknown(besselI(v,f),x,n,dir)

end_proc:
