/*--
        besselJ/Series -- the function attribut "series" for besselJ
--*/

besselJ::series :=
proc(v,f,x,n,dir, opt)
  local fv,k,l,s,sc,P,Q,xi,t,vabs,v2,x2,sw,tt;
begin
   fv:=float(v):
   if not(type(fv)=DOM_FLOAT or type(fv)=DOM_COMPLEX) or has(v,x) then 
      // proceed to Series::unknown below
   else
      // recursively expand the argument
      tt := Series::series(f, x, n, dir, opt);

      if dir <> Undirected then // directional expansion
        l:=limit(f,x,dir);
      elif domtype(tt) = Series::Puiseux then
        if ldegree(tt) = FAIL then // order too small
          l := FAIL;
        elif ldegree(tt) >= 0 then
          l := coeff(tt, x, 0);
        else
          return(FAIL)
        end_if
      else
        l := FAIL
      end_if;

      if iszero(l) then // expansion in 0: use definition 9.1.10 
         x2:=x^2;
         if iszero(v) then
            //Abramowitz and Stegun 9.1.12
            t:=1;
            s:=_plus(1,(t:=-t*1/4*x2/k^2)$ k=1..trunc(n/2));
         else
            //Abramowitz and Stegun 9.1.10 combined with
            // reflection formula 9.1.5
            // bug fix for negative indices
         if type(v)=DOM_INT  then
           vabs:=abs(v);
           sc:=sign(v)^v;
         else
          sc:=1;
          vabs:=v;
         end_if;
            s:=1/gamma(vabs+1):
            t:=s;
            s:=_plus(s,(t:=-t*1/4*x2/k/(k+vabs))$ k=1..trunc(n/2));
            //s:=(x/2)^vabs*(sign(v)^v)*s;
            s:=sc*x^vabs/2^vabs*s;
         end_if:
// More efficient: use create !!!
         s:=Series::series(s,x,n,dir, opt);
         if f=x then return(s) else return(s @ tt) end_if
      elif l=infinity or l=-infinity then 
         // formula 9.2.5 with 9.2.9 and 9.2.10 
         // changed z into 1/x (z->infinity when x->0, Right) 
         // 9.2.5 is Hankel's asymptotic formula which applies when
         // |arg(z)| < PI (i.e. excludes negative real axis)
         //
         // We keep in mind two reflection formulae which apply
         // to the complex plane for "v" integer:
         // 1) J_(-v) (z) = (-1)^v *J_(v) (z)  reflection formula    (9.1.5)
         // 2) J_v(-z) = (-1)^v * J_(v) (z)    analytic continuation (9.1.35)
         //
         // and in general, analytic continuation as expressed in 9.1.35:
         // J_(v) (z exp(m*PI*I) = exp(m*v*PI*I) J_(v) (z) ["m" is an integer]
         // MUST BE CAREFULLY WORKED OUT.
         // i.e. in the non-integer case, we have to be careful about expansions
         // about -infinity, a phase factor "sw" must be worked out.
         if type(v)=DOM_INT then
          vabs:=abs(v);
          v2:=2*vabs;  
          sc:=sign(l)^v;
          if v < 0 then
           sc:=sc*((-1)^v);
          end_if:
         else
          sc:=1;
          v2:=2*v;  
          vabs:=v; 
         end_if;
         t:=1;
//         P:=Series::series(_plus(1,
//           (t:=-t*1/128*(4*k+v2-3)*(4*k+v2-1)*(4*k-v2-1)*(4*k-v2-3)*x^2/(2*k-1)/k)
//               $ k=1..trunc((n-1)/2)),x,n);
// Puiseux::create is more efficient:
         P := [1, (0, (t := -t*1/128*(4*k + v2 - 3)*(4*k + v2 - 1)
                            *(4*k - v2 - 1)*(4*k - v2 - 3)/(2*k - 1)/k))
                  $ k = 1..trunc((n - 1)/2)];
         P := Series::Puiseux::create(1, 0, n, P, x, 0, dir);
         t:=1/8*(v2-1)*(v2+1);
//         t := t*x;
//         Q:=Series::series(_plus(t,(k2:=2*k; k4:=4*k;
//           t:=-t*1/128*(k4+v2-1)*(k4+v2+1)*(k4-v2+1)*(k4-v2-1)*x^2/k/(k2+1))
//               $ k=1..trunc((n-3)/2)),x,n);
// Puiseux::create is more efficient:
         Q := [t, (0, (t := -t*1/128*(4*k + v2 - 1)*(4*k + v2 + 1)
                            *(4*k - v2 + 1)*(4*k - v2 - 1)/(2*k + 1)/k))
                  $ k = 1..trunc((n - 3)/2)];
         Q := Series::Puiseux::create(1, 1, n, Q, x, 0, dir);
         if sign(l) > 0 or type(v)=DOM_INT then
          if f<>1/x and f<>-1/x then
              s:=Series::series(sign(l)/f,x,n,dir, opt);
              P:=P @ s;
              Q:=Q @ s
          end_if;
          xi:=sign(l)*f-(vabs/2+1/4)*PI;
          s := Series::series((1/sign(l)/f)^(1/2),x,n,dir, opt);
          P := P * s;
          Q := Q * s;
          return(sc*2^(1/2)/PI^(1/2)*
                 (P*cos::series(xi, x, n, dir, opt)-Q*sin::series(xi, x, n, dir, opt)));
         else
          if f<>-1/x then
            s:=Series::series(sign(l)/f,x,n,dir, opt);
            P:=P @ s;
            Q:=Q @ s
          end_if;
          xi:=sign(l)*f-(v/2+1/4)*PI;
          // phase factor sw represents f^v/((-f)^v) =(-1)^(v*signIm(f));
          // However, we make use of the identity:
          // (f^v/(-f)^v)*(-1/f)^(-1/2) = (-1)^((v+1/2)*signIm(f))*f^(-1/2)
          // i.e. the 1/sqrt(z) of Hankel's asymptotic expansion is modified
          // to ensure a clean result with the transformation z -> 1/x
          s := Series::series(f^(-1/2),x,n,dir, opt);
          P := P * s;
          Q := Q * s;
          sw:= (-1)^((v+1/2)*signIm(f));
          return(2^(1/2)/PI^(1/2)*sw*
                 (P*cos::series(xi, x, n, dir, opt)-Q*sin::series(xi, x, n, dir, opt)));
         end_if
      end_if
   end_if;

   Series::unknown(besselJ(v,f),x,n,dir)

end_proc:
