/*--
        besselK/Series -- the function attribut "series" for besselK
--*/

besselK::series :=
proc(v,f,x,n,dir, opt)
  local fv,h,k,l,mu,P,s,t,x2,res1,res2,vabs,tt,t1,t2;
begin
  fv:=float(v):
  if not(type(fv)=DOM_FLOAT or type(fv)=DOM_COMPLEX) or has(v,x) then
    // proceed to Series::unknown below
  else
    // recursively expand the argument
    tt := Series::series(f, x, n, dir, opt);

      if dir <> Undirected then // directional expansion
        l:=limit(f,x,dir);
      elif domtype(tt) = Series::Puiseux then
        if ldegree(tt) = FAIL then // order too small
          l := FAIL;
        elif ldegree(tt) >= 0 then
          l := coeff(tt, x, 0);
        else
          return(FAIL)
        end_if
      else
        l := FAIL
      end_if;

      if iszero(l) then 
      // expansion in 0: use definition 9.1.10 
        if type(v) <> DOM_INT then
          // Abramowitz and Stegun 9.6.2
          t := (PI/2)*(besselI(-v,x)-besselI(v,x))/sin(v*PI);
        else 
          x2:=x^2;
          if iszero(v) then
          // Abramowitz and Stegun 9.6.13
           if n > 2 then
            res2:=x2/4;
            h:=1; 
            t:=res2;
            for k from 2 to trunc(n/2) do
             h := h+1/k;
             t := t*1/4*x2/k^2:
             res2 := res2+t*h;
            end_for: 
           else
            res2:=0;
           end_if:
           
           if f=x then
             t:=-((ln(x/2)+EULER)*besselI(0,x)-res2); 
           else
            t1:=-(EULER*besselI(0,x)-res2):
            t2:=-besselI(0,x):
           end_if:
 
          else
           // Abramowitz and Stegun 9.1.11 combined with
           // reflection formula of 9.6.6
           vabs:=abs(v);
           res1:=fact(vabs-1);
           t:=res1;
           res1:=_plus(res1,(t:=-t*1/4/k*x2/(vabs-k)) $ k=1..vabs-1);
           t:=1/fact(vabs);
           res2:=(psi(vabs+1)-EULER)*t;
           for k from 1 to max(-1,trunc((n-vabs-1)/2)) do
             t:= t*1/4*x2/k/(vabs+k);
             res2:=res2+(psi(k+1)+psi(k+vabs+1))*t; 
           end_for: 
           if f=x then
           t := (1/2)*(x^(-vabs)/2^(-vabs)*res1+(-1)^vabs*x^vabs/2^vabs*res2) +  
                  ((-1)^(vabs+1))*ln(x/2)*besselI(vabs,x);
           else
            t1 :=(1/2)*(x^(-vabs)/2^(-vabs)*res1+(-1)^vabs*x^vabs/2^vabs*res2);
            t2 := ((-1)^(vabs+1))*besselI(vabs,x);
           end_if:
          end_if:
        end_if:
// More efficient: use create !!!
        //s:=series(t,x,n);
        //if f=x then return(s) else return(s @ tt) end_if
        if f=x or type(v) <> DOM_INT then
         return(Series::series(t,x,n) @ tt):
        else
         return( (Series::series(t1,x,n) @ tt) + ln(f/2)*(Series::series(t2,x,n) @ tt)):
        end_if:
      elif l=infinity then

         // Abramowitz and Stegun 9.7.2
         // changed z into 1/x (z->infinity when x->0, Right)
         // We keep in mind a reflection formula which applies
         // to the complex plane for "v" integer:
         // 1) K_(-v) (z) = K_(v) (z)  reflection formula    (9.6.6)
         mu:=4*v^2;
         t:=1;
//         P:=_plus(1,(t:=t*(mu-(2*k-1)^2)/k/8*x)$k=1..(n-1));
//         P:=Series::series(P,x,n);
// Puiseux::create is more efficient:
         P := [1, (t := t*(mu - (2*k - 1)^2)/k/8) $ k = 1..(n - 1)];
         P := Series::Puiseux::create(1, 0, n, P, x, 0, dir);
         if f<>1/x then
           s:=Series::series(1/f,x,n,dir, opt);
           P:=P @ s;
         end_if:
         P := P * Series::series(sqrt(1/f), x, n, dir, opt);
         return(P::dom::scalmult(P, PI^(1/2)/2^(1/2))
                * Series::series(exp(-f), x, n, dir, opt))
      end_if
   end_if;

   Series::unknown(besselK(v,f),x,n,dir)

end_proc:
