/*--
        besselY/Series -- the function attribut "series" for besselY
--*/

besselY::series :=
proc(v,f,x,n,dir, opt)
   local fv,h,k,l,P,Q,xi,s,sc,t,v2,x2,res1,res2,vabs,tt,t1,t2;
begin
   fv:=float(v):
   if not(type(fv)=DOM_FLOAT or type(fv)=DOM_COMPLEX) or has(v,x) then
      // proceed to Series::unknown below
   else
      // recursively expand the argument
      tt := Series::series(f, x, n, dir, opt);

      if dir <> Undirected then // directional expansion
        l:=limit(f,x,dir);
      elif domtype(tt) = Series::Puiseux then
        if ldegree(tt) = FAIL then // order too small
          l := FAIL;
        elif ldegree(tt) >= 0 then
          l := coeff(tt, x, 0);
        else
          return(FAIL)
        end_if
      else
        l := FAIL
      end_if;

      if iszero(l) then 
      // expansion in 0: use definition 9.1.10 
        if type(v) <> DOM_INT then
          // Abramowitz and Stegun 9.1.2
          t := (besselJ(v,x)*cos(v*PI)- besselJ(-v,x))/sin(v*PI):
        else 
          x2:=x^2:
          if iszero(v) then
           vabs:=0;
          // Abramowitz and Stegun 9.1.13
           if n > 2 then
            //res2:=-x2/4: wrong sign
            res2:=x2/4:
            h:=1: 
            t:=res2:
            for k from 2 to trunc(n/2) do
             h := h+1/k:
             //t := -t*1/4*x2/k: bug fixed.
             t := -t*1/4*x2/k^2:
             res2 := res2+t*h:
            end_for: 
           else
            res2:=0:
           end_if:
           if f=x then
            t:=(2/PI)*((ln(x/2)+EULER)*besselJ(0,x)+res2):
           else
            t1:=(2/PI)*(EULER*besselJ(0,x)+res2):
            t2:=(2/PI)*besselJ(0,x):
           end_if:
          else
           // Abramowitz and Stegun 9.1.11 combined with
           // reflection formula of 9.1.5
           vabs:=abs(v):
           res1:=fact(vabs-1):
           t:=res1:
           res1:=_plus(res1,(t:=t*1/4/k*x2/(vabs-k)) $ k=1..vabs-1):
           t:=1/fact(vabs):
           res2:=(psi(vabs+1)-EULER)*t:
           for k from 1 to max(-1,trunc((n-vabs-1)/2)) do
             t:= -t*1/4*x2/k/(vabs+k):
             res2:=res2+(psi(k+1)+psi(k+vabs+1))*t: 
           end_for: 
           if f=x then
            t := (sign(v)^v)*(-x^(-vabs)/2^(-vabs)*res1+
                  2*ln(x/2)*besselJ(vabs,x)-x^vabs/2^vabs*res2)/PI:
           else
            t1 := (sign(v)^v)*(-x^(-vabs)/2^(-vabs)*res1-x^vabs/2^vabs*res2)/PI:
            t2 := 2*(sign(v)^v)*besselJ(vabs,x)/PI:
           end_if:
          end_if:
        end_if:
// More efficient: use create !!!
        if f=x or type(v) <> DOM_INT then
         return(Series::series(t,x,n,dir, opt) @ tt):
        else
         return( (Series::series(t1,x,n,dir, opt) @ tt) + ln(f/2)*(Series::series(t2,x,n, dir, opt) @ tt)):
        end_if:
        //if f=x then return(s) else return(s @ tt) end_if
      elif l=infinity then
         // formula 9.2.6 with 9.2.9 and 9.2.10 
         // changed z into 1/x (z->infinity when x->0+) 
         // 9.2.6 is Hankel's asymptotic formula which applies when
         // |arg(z)| < PI (i.e. excludes negative real axis)
         //
         // We keep in mind a reflection formula which applies
         // to the complex plane for "v" integer:
         // 1) Y_(-v) (z) = (-1)^n *Y_(v) (z)  reflection formula    (9.1.5)
         sc:=1:
         if type(v)=DOM_INT then
          vabs:=abs(v):
          v2:=2*vabs:
          if v < 0 then sc:=sc*((-1)^v): end_if:
         else
          v2:=2*v:
          vabs:=v:
         end_if:
         t:=1:
//         P:=Series::series(_plus(1,
//             (t:=-t*1/128*(4*k+v2-3)*(4*k+v2-1)*(4*k-v2-1)*(4*k-v2-3)*x^2/(2*k-1)/k)
//             $ k=1..trunc((n-1)/2)),x,n):
// Puiseux::create is more efficient:
         P := [1, (0, (t := -t*1/128*(4*k + v2 - 3)*(4*k + v2 - 1)
                            *(4*k - v2 - 1)*(4*k - v2 - 3)/(2*k - 1)/k))
                  $ k = 1..trunc((n - 1)/2)]:
         P := Series::Puiseux::create(1, 0, n, P, x, 0, dir);
         t:=1/8*(v2-1)*(v2+1):
//         t := t*x;
//         Q:=Series::series(_plus(t,
//             (t:=-t*1/128*(4*k+v2-1)*(4*k+v2+1)*(4*k-v2+1)*(4*k-v2-1)*x^2/k/(2*k+1))
//             $ k=1..trunc((n-3)/2)),x,n):
// Puiseux::create is more efficient:
         Q := [t, (0, (t := -t*1/128*(4*k + v2 - 1)*(4*k + v2 + 1)
                            *(4*k - v2 + 1)*(4*k - v2 - 1)/(2*k + 1)/k))
                  $ k = 1..trunc((n - 3)/2)]:
         Q := Series::Puiseux::create(1, 1, n, Q, x, 0, dir);
         if f<>1/x then
           s:=Series::series(1/f,x,n,dir, opt);
           P:=P @ s;
           Q:=Q @ s
         end_if;
         s := Series::series(sqrt(1/f), x, n, dir, opt);
         P := P * s;
         Q := Q * s;
         xi:=f-(vabs/2+1/4)*PI:
         return(sc*2^(1/2)/PI^(1/2)*
                (P*sin::series(xi, x, n, dir, opt)+
                 Q*cos::series(xi, x, n, dir, opt))):
      end_if
   end_if;

   Series::unknown(besselY(v,f),x,n,dir)

end_proc:
