//    

/*--
	cos/Series -- the function attribut "series" for cos
--*/

cos::series :=
proc(f,x,n,dir,opt)
  local t,k,a,tc,ts;
begin   
   if f=x then
      Series::Puiseux::create(1,0,2*((n+1) div 2),Series::gen["cos"](n),x,0,dir)
   else
      t:=Series::series(f,x,n,dir,opt);
      if domtype(t)<>Series::Puiseux then
         return(FAIL)
      end_if;
      k:=ldegree(t);
      if k=FAIL then // t = O(..)
         k:=Series::Puiseux::order(t);
         if k > 0 then
            return(Series::Puiseux::one(x, n, dir)+t^2)
         else 
	    Series::error("order too small")
         end_if
      elif k>0 then 
	 Series::Puiseux::_fconcat(
            Series::Puiseux::create(1,0,2*((n+1) div 2),Series::gen["cos"](n),x,0,dir)
	 ,t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         // cos(a+t)=cos(a)*cos(t)-sin(a)*sin(t) 
         if iszero(cos(a)) then
           -sin(a)*sin::series(t,x,n,dir,opt)
         else
           cos(a)*cos::series(t,x,n,dir,opt)-sin(a)*sin::series(t,x,n,dir,opt)
         end_if
      else // expansion around infinity
        if dir <> Undirected then
          // directed expansion
          // a := non-positive order part of t
          a := expr(Series::Puiseux::truncate(t, 0));
          if coeff(t, 0) <> FAIL then
            a := a + coeff(t, 0)
          end_if;
          f := normal(f - a);
          if contains({infinity, -infinity}, limit(a, x, dir)) then
            if iszero(f) then
              Series::Puiseux::const(cos(a), x, n, dir)
            else
              // cos(a)*cos(f) + sin(a)*sin(f)
              ts := Series::series(sin(f), x, n, dir,opt);
              tc := Series::series(cos(f), x, n, dir,opt);
              Series::Puiseux::scalmult(tc, cos(a))
              - Series::Puiseux::scalmult(ts, sin(a))
            end_if;
          else
            userinfo(2, "unable to compute series expansion");
            FAIL
          end_if
        else // undirected expansion
          userinfo(2, "unable to compute series expansion");
          FAIL
        end_if;
      end_if
   end_if
end_proc:

// ensure that domain Series is loaded
Series:

Series::gen["cos"]:=proc(n) local i,t;
begin
   t:=1; 
   [1,(0,(t:=-t/(2*i-1)/(2*i)))$i=1..(n-1) div 2]
end_proc:
Series::gen["cos"](0):=[]:

// end of file 
