//    

/*--
	cosh/Series -- the function attribut "series" for cosh
--*/

cosh::series := proc(f,x,n,dir,opt)
   local t,k,a;
begin   
   if f=x then
      Series::Puiseux::create(1,0,2*((n+1) div 2),Series::gen["cosh"](n),x,0,dir)
   else
      t:=Series::series(f,x,n,dir, opt);
      if domtype(t)<>Series::Puiseux then
         return(FAIL)
      end_if;
      k:=ldegree(t);
      if k=FAIL then // t = O(..)
         k:=Series::Puiseux::order(t);
         if k > 0 then
           return(Series::Puiseux::one(x, n, dir)+t^2)
         else
	   Series::error("order too small");
         end_if
      elif k>0 then
         Series::Puiseux::_fconcat(
             Series::Puiseux::create(1,0,2*((n+1) div 2),Series::gen["cosh"](n),x,0,dir)
         ,t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         // cosh(a+t)=cosh(a)*cosh(t)+sinh(a)*sinh(t) 
         if iszero(cosh(a)) then
           sinh(a)*sinh::series(t,x,n,dir,opt)
         else
           cosh(a)*cosh::series(t,x,n,dir,opt)+
           sinh(a)*sinh::series(t,x,n,dir,opt)
         end_if
      else // expansion around infinity
         Series::series((exp(f) + exp(-f))/2, x, n, dir, opt)
      end_if
   end_if
end_proc:

// ensure that domain Series is loaded
Series:

Series::gen["cosh"]:=proc(n) local i,t;
begin
   t:=1; 
   [1,(0,(t:=t/(2*i-1)/(2*i)))$i=1..(n-1) div 2]
end_proc:
Series::gen["cosh"](0):=[]:

// end of file 
