
floor::series :=
proc(f,x,n,dir, opt) 
  name floor::series;
  local l, t, d;
begin

  if dir <> Undirected then // directional expansion
    l:=limit(f,x,dir);
    if has(l, infinity) then
       // use floor(f) =  f - frac(f)
       return( Series::series(f, x, n, dir, opt)
              -Series::Puiseux::const(frac(f), x, n, dir));
    end_if:
    if domtype(Re(l)) <> DOM_INT then
      l := floor(l);
      if domtype(Re(l)) = DOM_INT then
        return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
      end_if
    else // Re(l) is an integer
      if dir = hold(Real) then
        userinfo(1,
                 "no real series expansion of floor(x) around discontinuity x = "
                 . expr2text(l));
        return(FAIL)
      end_if;

      // left or right expansion
      // one might copy the code from ceil::series, but it may be better
      // to leave it in one place, so let us use the identity
      // floor(x) = -ceil(-x) 
      t:= ceil::series(-f, x, n, dir, opt);
      if t = FAIL then
        return(FAIL)
      else
        return(-t)
      end_if;
    end_if;
  end_if;

  // recursively expand the argument
  t := Series::series(f, x, n, dir, opt);

  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then
      Series::error("order too small")
    elif d >= 0 then // expansion around a finite point 
      l := coeff(t, x, 0);
      if domtype(Re(l)) <> DOM_INT and domtype(Im(l)) <> DOM_INT then
        l := floor(l);
        if domtype(Re(l)) = DOM_INT and domtype(Im(l)) = DOM_INT then
          return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
        end_if
      else
        userinfo(1,
          "no series expansion of floor(x) around discontinuity x = "
          . expr2text(l));
        return(FAIL);
      end_if
    else // ldegree(t) < 0
      // use floor(f) =  f - frac(f)
      return(t - Series::Puiseux::const(frac(f), x, n, dir))
    end_if
  end_if;

  Series::unknown(floor(f),x,n,dir)

end_proc:
