/*--
	fresnelC/Series -- the function attribut "series" for fresnelC
	analogous to erf::series
--*/

fresnelC::series :=
proc(f,x,n,dir, opt)
  local t,s,d,k;
begin
  // recursively expand the argument
  t:=Series::series(f,x,n,dir, opt);

  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then // t = O(..)
      d:=Series::Puiseux::order(t);
      if d > 0 then
        return(t)
      else
        Series::error("order too small");
        return(FAIL);
      end_if
    elif d < 0 then // f goes to +/-infinity
      s := FAIL;
      if dir <> Undirected then
        s := limit(lmonomial(t), x, dir);
        if s = FAIL or type(s) = "limit" then
          s := FAIL
        elif domtype(s) = Dom::Interval then
          s := op(sign(s))
        else
          s := sign(s)
        end_if
      end_if;
      if s=1 then // +infinity
        s:=Series::Puiseux::create(1,1,n,Series::gen["fresnelC"](n,1/x),x);
        s:=Series::Puiseux::_fconcat(s, 1/t);
        return(1/2 + s)
      elif s=-1 then // -infinity
        s:=Series::Puiseux::create(1,1,n,Series::gen["fresnelC"](n,1/x),x);
        s:=Series::Puiseux::_fconcat(s, -1/t);
        return(-1/2 - s)
      else
        userinfo(2,"unable to compute expansion");
        return(FAIL)
      end_if
    elif d > 0 then // expansion around 0
      // s := series(fresnelC(x), x)
      // = x * sum( (-1)^k*PI^(2*k)/4^k/(4*k+1)/(2*k)! * x^(4*k)
       s := 1;
       s := [s, (0, 
                 0, 
                 0, 
                 (s:= -s*PI^2*(4*k - 3)/(4*k + 1)/(2*k - 1)/(2*k)/4)
                ) $ k = 1.. (n - 1) div 4];

       s := Series::Puiseux::create(1, 1, n + 1, s, x, 0, dir);
       if f = x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if
     end_if
   end_if;
   Series::unknown(fresnelC(f),x,n,dir)

end_proc:

// ensure that domain Series is loaded
Series:

// expansion of fresnelC(x) - 1/2 around infinity, leading order is 1
// This is identical to Series::gen["erfc"]
Series::gen["fresnelC"]:=proc(n,x) 
local s, c, t, i;
begin
   s:=  sin(PI*x^2/2);
   c:=  cos(PI*x^2/2);
   [(t:= 1/PI; s*t), 
     0,
    (t:= -t/PI; c*t), 
    (0, (t:=  t* (4*i - 1)/PI; s*t), 
     0, (t:= -t* (4*i + 1)/PI; c*t) ) $i=1..(n-1) div 4
   ];
end_proc:

// end of file

