//    

/*--
	gamma/Series -- the function attribut "series" for gamma
--*/

gamma::series := proc(f,x,n,dir, opt)
   local l,i,a,t,d;
begin

   if dir <> Undirected then // directed expansion
     l:=limit(f,x,dir);
     if is(-l, Type::NonNegInt) = TRUE then // simple pole 
//       # use gamma(x+1)=x*gamma(x), formula 6.1.15 #
//       p:=_mult(f+i $ i=0..-l);
//       return(series(gamma(f-l+1)/p,x,n,dir))
// better: use reflection formula
         return(simplify(Series::series(PI / sin(PI*f) / gamma(1 - f), x, n, dir, opt)))
     elif Re(l)=infinity then // Stirling formula, see 6.1.40 
       a := Series::series(sqrt(2)*sqrt(PI)*exp((f - 1/2)*(ln(f) - 1) - 1/2),
                           x, n, dir, opt);
// More efficient: use create and concat !!!
       l:=bernoulli(2*i)/2/i/(2*i-1)/f^(2*i-1)$i=1..max(1,n-2);
       return(a * Series::series(exp(_plus(l)),x,n,dir, opt))
     elif l=-infinity then 
//       // use reflection formula
//       return(Series::series(PI / sin(PI*f) / gamma(1 - f), x, n, dir))
// does not work since gseries cannot handle "sin"
       return(FAIL)
     end_if;
   end_if;
 
   // recursively expand the argument into a series
   t := Series::series(f,x,n,dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then
       Series::error("order too small");
     elif d >= 0 then
       l := coeff(t, x, 0);
       if is(-l, Type::NonNegInt) = TRUE then // simple pole, use refl. formula
         return(simplify(Series::series(PI / sin(PI*f) / gamma(1 - f), x, n, dir, opt)))
       end_if;
     else // ldegree(t) < 0
       return(FAIL)
     end_if;
   end_if;

   Series::unknown(gamma(f),x,n,dir)

end_proc:
