// series expansion of the generalized hypergeometric function
//
//
/*--
     hypergeom/Series -- the function attribut "series" for hypergeom
--*/

hypergeom::series := proc(a, b, f, x, n, dir, opt)
    local a0, b0, as, bs, ak, i, j, k, bk, s, sc, t, tt, l;
begin

    // recursively expand the argument
    tt := Series::series(f, x, n, dir, opt);

    // determine expansion point
    if dir <> Undirected then // directional expansion
      l := limit(f, x, dir);
    elif domtype(tt) = Series::Puiseux then // undirected expansion
      if ldegree(tt) = FAIL then // order too small
        l := FAIL;
      elif ldegree(tt) >= 0 then // nonnegative valuation
        l := coeff(tt, x, 0); // expansion point = coefficient of x
      else // negative valuation
        l := FAIL
      end_if
    else // could not determine expansion point
      l := FAIL
    end_if;

    // remove common terms (PBM 7.2.3  no. 7
    // IMPORTANT Note: this rule applies even when the common terms are
    // zero or negative integers
    // (see e.g. Luke. Vol. 1, p. 41 section 3.1 (25)
    as := a:
    bs := b:
    if as <> [] and bs <> [] then
       for i from nops(as) downto 1 step 1 do
          j := contains(bs, as[i]):
          if j <> 0 then
             as := subsop(as, i = null()):
             bs := subsop(bs, j = null()):
          end_if:
       end_for:
    end_if:

    // handle polynomial and denominator singularity cases
    a0 := specfunc::Hypergeom::sel(as):
    b0 := specfunc::Hypergeom::sel(bs):

    if iszero(l) // expansion in 0
     or (a0 > b0 and -a0 < n) then // hypergeom is a poly. of degree -a0 < n
        // I'm not sure whether this is really necessary (Juergen)

      if has([as, bs], x) then // series variable occurs in the parameters
        // return symbolic series call
        return(FAIL);
      end_if;

//    t:=1;
//    s:=t;
//    for k from 1 to n do
//      ak:=_mult(op(map(as,((x,k)->x+k-1),k)));
//      bk:=_mult(op(map(bs,((x,k)->x+k-1),k)));
//      t:=t*ak*x/bk/k;
//      s:=s+t;
//      if t=0 then break: end_if;
//    end_for;
//    s:=series(s,x,n);
// Puiseux::create is more efficient:
      t := 1;
      s := [1];
      for k from 1 to n - 1 do
        ak := _mult(op(map(as,((z, k) -> z + k - 1), k)));
        bk := _mult(op(map(bs,((z, k) -> z + k - 1), k)));
        t := t*ak/bk/k;
        if t = 0 then
          break
        end_if;
        s := s . [t];
      end_for;
      s := Series::Puiseux::create(1, 0, n, s, x, 0, dir);

      if a0 > b0 and -a0 < n then
        // s is in fact a polynomial of degree < n
        subs(expr(s), x = tt, EvalChanges);
      elif f = x then // shortcut
        s
      else 
        s:= s @ tt;
        if domtype(s) = Series::Puiseux then
           s:= Series::Puiseux::truncate(s, n);
        end_if:
      end_if:

    elif nops(as) = 1 and nops(bs) = 1 and abs(l) = infinity then
      // expansion around +-infinity

      if sign(l) = 1 or
       (sign(l) = -1 and testtype(bs[1] - as[1], Type::NegInt)) then 
   	// standard confluent hypergeometric function
   	// A & S eq. 13.5.1. (dominant term)
	t := 1;
    	s := [t];
    	for k from 1 to n - 1 do
          t := -t*(as[1] - k)*(bs[1] - as[1] + k - 1)/k;
          if t = 0 then
            break
          end_if;
          s := s . [t];
    	end_for;
        sc := (gamma(bs[1])/gamma(as[1]))*exp(sign(l)*f)
              *((sign(l)*f)^(as[1] - bs[1]));
      else
   	// eq. 13.5.1. (sub-dominant term) fudged for the numerics of MuPAD.
	t := 1;
    	s := [t];
    	for k from 1 to n - 1 do
      	  t := t*(as[1] - bs[1] + k)*(as[1] + k - 1)/k;
          if t = 0 then
            break
          end_if;
          s := s . [t];
    	end_for;
        sc := exp(PI*I*as[1])*(gamma(bs[1])/gamma(bs[1] - as[1]))*(f^(-as[1]));
      end_if;
      s := Series::Puiseux::create(1, 0, n, s, x, 0, dir);
      
      if f = sign(l)/x then // shortcut
        // Voldemort's original code:
        // sc*s;
        Series::series(sc, x, n, dir, opt) * s;
      else 
        // Voldemort's original code:
        // sc * (s @ Series::series(sign(l)/f, x, n, dir)); 
        Series::series(sc, x, n, dir, opt) *
        (s @ Series::series(sign(l)/f, x, n, dir, opt)); 
      end_if:

    else
      // try formal Taylor expansion
      Series::unknown(hypergeom(as, bs, f), x, n, dir);
    end_if; 

end_proc:
