/*--
inverfc::series -- the function attribut "series" for inverfc
--*/

inverfc::series := proc(f, x, n, dir, opt)
begin
  // Using inverfc(x) = inverf(1 - x) we just call inverf::series:
  return(// in case of Taylor expansions, the result contains
         // symbolic calls of inverf. Rewrite them in terms of
         // symbolic inverfc calls:
         subs(inverf::series(1 - f, x, n, dir, opt),
              hold(inverf) = proc(x) begin inverfc(1 - x) end_proc,
              EvalChanges));
end_proc:
