/*--
  lngamma/Series -- the function attribut "series" for lngamma
--*/

lngamma::series := proc(f,x,n,dir, opt)
   local l,i,k,t,d,m,fpm,fml;
begin
   // special case (for speed):
   if f = x then
     return(Series::Puiseux::create(1, 0, n, Series::gen["lngamma"](n, x), x, 0, dir));
   end_if:

   if dir <> Undirected then // directed expansion
      l:=limit(f,x,dir);
      if l = infinity then
        // The following representation is valid for complex values of f:
        return(Series::series(f*ln(f) - f - ln(f)/2 + ln(2)/2 + ln(PI)/2
                              +_plus(bernoulli(2*i)/(2*i)/(2*i - 1)/f^(2*i-1)
                                     $ i = 1 .. trunc(n/2)), x, n, dir, opt));
/*
      elif l = -infinity then
        // The following representation is valid only for real values of f.
        // We do not return it, because otherwise
        //   series(lngamma( x - I/x), x = -infinity)
        // would return an incorrect expansion
        return(Series::series(- lngamma(-f)
                              + ln(PI) 
                              + ln(1/sin(PI*f))
                              - ln(-f)
                              + 2*PI*I*floor(f/2),
                              x, n, dir, opt));
*/
      end_if;
   end_if:

   // recursively expand the argument into a series
   t := Series::series(f,x,n,dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then
       Series::error("order too small");
     elif d >= 0 then
       l := coeff(t, x, 0);
       if is(l in Z_) = TRUE and
          is(l <= 0)  = TRUE then 
         m:= -l;
         if m = 0 then 
           // concatenation of expansion around zero and t = series(f, x=0)
           return(Series::Puiseux::create(1, 0, n, Series::gen["lngamma"](n, x), x, 0, dir)
                  @ t);
         else
           // The following fpm is the series of f+m around x = 0:
           fpm := t + Series::Puiseux::const(m, x, n, dir, opt);

           // Use lngamma(f)
           // = lngamma(f+m) - sum(ln(k + f), k = 0..m-1)
           // = lngamma(f+m) - sum(ln(m-k + f), k = 1..m)
           // = lngamma(f+m) - sum(ln(-k * (1 - fpm/k)), k = 1..m)
           // = lngamma(f+m) - ln(m!) + m*PI*I*signIm(f)
           //    - sum((f+m)/k + (f+m)^2/k^2/2 + (f+m)^3/k^3/3 + ...), k=1..m)
           // to trace the series around -m back to the series around 0.
           // Use sum(1/k^j, k = 1..m) = (psi(m+1, k-1) - psi(1, k-1))/(k-1)!.
           return( Series::series(lngamma(f + m), x, n, dir, opt)
                 - Series::series(ln(m!) + m*PI*I*signIm(f), x, n, dir, opt)
                 - _plus((-1)^k*fpm^k/k!*(psi(m+1, k-1) - psi(1, k-1)) $ k = 1..n-1)
                 );
         end_if:
       elif is(l in Z_) = FALSE and
           is(l <= 0) = TRUE then
           fml := t - Series::Puiseux::const(l, x, n, dir, opt);
           m:= ceil(-l); // m + l = l + ceil(-l) = frac(l)
                         // 1 - frac(l) = frac(-l)
          
           // Use lngamma(f)
           // = lngamma(f+m) - sum(ln(k + f), k = 0..m-1)
           // = lngamma(f+m) - sum(ln(m-k + f), k = 1..m)
           // = lngamma(f+m) - sum(ln(m+l-k + f-l), k = 1..m)
           // = lngamma(f+m) - sum(ln(-k+m+l * (1 - fml/(k-m-l)), k = 1..m)
           // = lngamma(f+m) - ln(m!) + m*PI*I*signIm(f)
           //    - sum((f-l)/(k-m-l) + (f-l)^2/(k-m-l)^2/2 + (f-l)^3/(k-m-l)^3/3 + ...), k=1..m)

           return( Series::series(lngamma(f + frac(l) - l), x, n, dir, opt)
                 - Series::series(ln(pochhammer(frac(-l), m)) + m*PI*I*signIm(f), x, n, dir, opt)
                 - _plus((-1)^k*fml^k/k!*(psi(1 - l, k-1) - psi(frac(-l), k-1)) $ k = 1..n-1)
                 );
       end_if;
     else // ldegree(t) < 0
       // expansion around infinity.
       // This should not occur because this was handled up above.
       return(FAIL)
     end_if;
   end_if;

   Series::unknown(lngamma(f),x,n,dir)
end_proc:

// generate the coefficients of the expansion around x = 0:
Series::gen["lngamma"] := proc(n, x)
local j;
begin
   if n = 0 then 
      []
   elif n = 1 then 
      [-ln(x)] 
   else
      [-ln(x), -EULER, (-1)^j*zeta(j)/j $ j = 2 .. n-1]
   end_if:
end_proc:
