//   $$ 

/*--
	tan/Series -- the function attribut "series" for tan
--*/

/* tan(x) = sum(2^(2n)*(2^(2n) - 1)/(2n)!*(-1)^(n-1)*B[n]*x^(2n-1),n=1..infinity)
   		where B = coeff(series(x/(exp(x)-1),x,..) are the Bernoulli numbers
*/

tan::series :=
proc(f,x,n,dir,opt)
  local t,k,a,ts,tc;
begin
  if f=x then
    return(Series::Puiseux::create(1,1,2*((n+1) div 2)+1,Series::gen["tan"](n),x,0,dir)
          )
  end_if;
  
  t:=Series::series(f,x,n,dir,opt);
  if domtype(t)<>Series::Puiseux then
    return(FAIL)
  end_if;
  k:=ldegree(t);
  if k=FAIL then // t = O(..)
    k:=Series::Puiseux::order(t);
    if k > 0 then
      return(t)
    else
      Series::error("order too small");
    end_if
  elif k>0 then
    Series::Puiseux::_fconcat(
        Series::Puiseux::create(1,1,2*((n+1) div 2)+1,
                                Series::gen["tan"](n),x,0,dir),
        t)
  elif k=0 then
    a:=lcoeff(t);
    t:=f-a;
    // tan(a+t)=(tan(a) + tan(t))/(1 - tan(a)*tan(t))
    if traperror(tan(a)) <> 0 then // we've hit PI/2 and the like
      Series::series(sin(f),x,n,dir,opt)/
      Series::series(cos(f),x,n,dir,opt);
    else
      if iszero(tan(a)) then
        tan::series(t,x,n,dir,opt)
      else
        t:= tan::series(t,x,n-1,dir,opt):
        Series::Puiseux::truncate((tan(a) + t)/ (1 - tan(a)*t), n);
      end_if
    end_if;
  else // expansion around infinity
    if dir <> Undirected then
      // directed expansion
      // a := non-positive order part of t
      a := expr(Series::Puiseux::truncate(t, 0));
      if coeff(t, 0) <> FAIL then
        a := a + coeff(t, 0)
      end_if;
      if traperror(tan(a)) <> 0 then // we've hit PI/2 and the like
        Series::series(sin(f),x,n,dir,opt)/Series::series(cos(f),x,n,dir,opt)
      elif contains({infinity, -infinity}, limit(a, x, dir)) then
        f := normal(f - a);
        if iszero(f) then
          Series::Puiseux::const(tan(a), x, n, dir);
        else
          // tan(a+t)=(tan(a) + tan(t))/(1 - tan(a)*tan(t))
          ts := Series::series(tan(f), x, n, dir,opt);
          tc := Series::Puiseux::scalmult(ts, tan(a));
          Series::Puiseux::_plus(ts, tan(a))
          / (1 - Series::Puiseux::scalmult(tc, tan(a)));
        end_if;
      else
        userinfo(2, "unable to compute series expansion");
        FAIL
      end_if
    else // undirected expansion
      userinfo(2, "unable to compute series expansion");
      FAIL
    end_if; // dir <> Undirected
  end_if; // case analysis on k
end_proc:

// ensure that domain Series is loaded
Series:

// tan(x) = sum(2^(2n + 2)*(2^(2n + 2) - 1)/(2n + 2)!*(-1)^n*B[2n+2]*x^(2n+1),n=0..infinity)
Series::gen["tan"]:=proc(n) 
local i, t, a;
begin
   // have to keep track of a := 2^(2n + 2) - 1
   //  t := the 'rest' of coefficient besides a and B
   a:=3;
   t:=2;
   [1,(0,(a:= 4*(a+1)-1: t:=-t*4/(2*i + 2)/(2*i+1): t*bernoulli(2*i+2)*a))  $i=1..(n-1) div 2]
end_proc:
Series::gen["tan"](0):=[]:
Series::gen["tan"](1):=[1]:

// end of file 
