/*
 * series slot of trunc - computes series(trunc(f), x, n, dir)
 * analogous to floor and ceil
 */

trunc::series :=
proc(f,x,n,dir, opt)
  local l, t, d, s;
begin

  if dir <> Undirected then // directional expansion
    l:=limit(f,x,dir);
    if l = infinity then
       // use trunc(f) = floor(f) =  f - frac(f)
       return( Series::series(f, x, n, dir, opt)
              -Series::Puiseux::const(frac(f), x, n, dir));
    end_if:
    if l = -infinity then
       // use trunc(f) = ceil(f) =  f + frac(-f)
       return( Series::series(f, x, n, dir, opt)
              +Series::Puiseux::const(frac(-f), x, n, dir));
    end_if:
    if l = I*infinity then
       // use trunc(f) = floor(f) =  f - frac(f)
       return( Series::series(Im(f)*I, x, n, dir, opt)
              -Series::Puiseux::const(frac(Im(f)*I), x, n, dir));
    end_if:
    if l = -I*infinity then
       // use trunc(f) = floor(f) =  f + frac(-f)
       return( Series::series(Im(f)*I, x, n, dir, opt)
              +Series::Puiseux::const(frac(-Im(f)*I), x, n, dir));
    end_if:  
    if has(l, infinity) then
       // the case l = symbolic*infinity 
       return(FAIL);
    end_if:
          
    
    if Re(l) = 0 or domtype(Re(l)) <> DOM_INT then
      l := trunc(l);
      if domtype(Re(l)) = DOM_INT then
        return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
      end_if
    else // Re(l) is an integer
      userinfo(1,
        "no real series expansion of trunc(x) around discontinuity x = "
        . expr2text(l));
      return(FAIL);
    end_if;
  end_if;

  // recursively expand the argument
  t := Series::series(f, x, n, dir, opt);

  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then
      Series::error("order too small")
    elif d >= 0 then // expansion around a finite point 
      l := coeff(t, x, 0);
      if l = 0 or 
         (domtype(Re(l)) <> DOM_INT and domtype(Im(l)) <> DOM_INT) then
        l := trunc(l);
        if domtype(Re(l)) = DOM_INT and domtype(Im(l)) = DOM_INT then
          return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
        end_if
      else
        userinfo(1,
          "no series expansion of trunc(x) around discontinuity x = "
          . expr2text(l));
        return(FAIL);
      end_if
    else // ldegree(t) < 0
      s:= sign(lcoeff(t));
      if s = 1 then
         // trunc(f) = floor(f) = f - frac(f)
         return(t - Series::Puiseux::const(frac(f), x, n, dir))
      elif s = -1 then
         // trunc(f) = ceil(f) = f + frac(-f)
         return(t + Series::Puiseux::const(frac(-f), x, n, dir))
      else
        return(FAIL)
      end_if:
    end_if
  end_if;

  Series::unknown(trunc(f),x,n,dir)

end_proc:
