
zeta::series :=
proc(f, m, x,n,dir, opt) // series(zeta(f, m), x = 0, n, dir)
  local l, t, d, k;
begin
  if f = x + 1 then
    // Insert the formulas for series(zeta(1 + x, 0), x = 0, n)
    // explicitly for n = 0,1,..,6, because the generic computation 
    // for general n is very expensive and yields a rather complicated
    // result that requires simplification:
    // zeta(1 + x, x), x = 1 = t[-1]/(x-1) + t[0] + t[1]*(x - 1) + ...
    if n = 0 then
       return(Series::Puiseux::zero(x, -1, dir));
    end_if;
    case n
/* ------------------
    // Do **not** do the explicit form for n = 7, it
    // slows down the computation of the series!
    of 7 do
       t[5]:= 1/288*PI^2*zeta(0, 4) + 1/640*PI^4*zeta(0, 2)
        + 1/60*ln(PI)*zeta(0, 5) + 1/720*EULER^6 
        - 1/24*ln(2)^2*zeta(0, 4) - 1/9*ln(2)^3*zeta(3) 
        + 1/18*ln(2)^3*zeta(0, 3) - 1/24*ln(2)^4*zeta(0, 2)
        - 79/967680*PI^6 - 1/1280*EULER^2*PI^4 - 1/576*EULER^4*PI^2 
        - 1/30*EULER*ln(PI)^5 - 1/144*ln(2)^6 - 1/16*EULER^2*ln(2)^4
        - 1/18*EULER^3*ln(2)^3 - 1/48*EULER^4*ln(2)^2 + 1/18*zeta(3)^2 
        + 1/192*PI^2*ln(2)^4 + 1/1280*PI^4*ln(2)^2 - 1/24*ln(PI)*ln(2)^5
        - 1/24*ln(PI)^5*ln(2) - 1/24*ln(PI)^2*zeta(0, 4) 
        - 1/9*ln(PI)^3*zeta(3) + 1/18*ln(PI)^3*zeta(0, 3)
        - 1/24*ln(PI)^4*zeta(0, 2) - 1/144*ln(PI)^6 + 1/5*EULER*zeta(5) 
        + 1/60*EULER*zeta(0, 5) - 1/16*EULER^2*ln(PI)^4 
        - 1/18*EULER^3*ln(PI)^3 - 1/48*EULER^4*ln(PI)^2 
        + 1/192*PI^2*ln(PI)^4 + 1/1280*PI^4*ln(PI)^2 
        + 1/60*ln(2)*zeta(0, 5) - 5/48*ln(PI)^2*ln(2)^4 
        - 5/36*ln(PI)^3*ln(2)^3 - 5/48*ln(PI)^4*ln(2)^2 
        + 1/9*zeta(3)*zeta(0, 3) - 1/30*EULER*ln(2)^5 - 1/360*zeta(0, 6) 
        - 1/24*EULER^2*zeta(0, 4) + 1/18*EULER^3*zeta(3) 
        + 1/18*EULER^3*zeta(0, 3) - 1/24*EULER^4*zeta(0, 2) 
        - 1/12*EULER*ln(2)*zeta(0, 4) - 1/3*EULER*ln(PI)^2*ln(2)^3 
        - 1/3*EULER*ln(PI)^3*ln(2)^2 - 1/4*EULER^2*ln(PI)*ln(2)^3
        - 1/4*EULER^2*ln(PI)^3*ln(2) - 1/6*EULER^3*ln(PI)*ln(2)^2 
        - 1/6*EULER^3*ln(PI)^2*ln(2) + 1/48*PI^2*ln(PI)*ln(2)^3 
        + 1/48*PI^2*ln(PI)^3*ln(2) - 1/3*EULER*zeta(3)*zeta(0, 2) 
        - 1/4*EULER^2*ln(PI)^2*zeta(0, 2) + 1/48*PI^2*ln(PI)^2*zeta(0, 2) 
        - 1/3*ln(2)*zeta(3)*zeta(0, 2) - 1/4*ln(PI)^2*ln(2)^2*zeta(0, 2)
        - 1/72*EULER*PI^2*zeta(3) - 1/72*EULER*PI^2*zeta(0, 3) 
        + 1/96*EULER^2*PI^2*ln(PI)^2 - 1/12*EULER*ln(PI)*zeta(0, 4)
        - 1/6*EULER*ln(2)^2*zeta(3) + 1/6*EULER*ln(2)^2*zeta(0, 3)
        - 1/6*EULER*ln(2)^3*zeta(0, 2) + 1/6*EULER^2*ln(2)*zeta(0, 3)
        - 1/6*EULER^3*ln(2)*zeta(0, 2) - 3/8*EULER^2*ln(PI)^2*ln(2)^2
        - 1/72*PI^2*ln(2)*zeta(0, 3) + 1/32*PI^2*ln(PI)^2*ln(2)^2 
        - 1/12*ln(PI)*ln(2)*zeta(0, 4) - 1/3*ln(PI)*zeta(3)*zeta(0, 2) 
        + 1/72*EULER*PI^2*ln(2)^3 - 1/6*EULER*ln(PI)*ln(2)^4 
        - 1/6*EULER*ln(PI)^4*ln(2) -1/24*EULER^4*ln(PI)*ln(2) 
        + 1/48*EULER^2*PI^2*zeta(0, 2) + 1/640*PI^4*ln(PI)*ln(2)
         - 1/6*EULER*ln(PI)^2*zeta(3) + 1/6*EULER *ln(PI)^2*zeta(0, 3) 
        - 1/6*EULER*ln(PI)^3*zeta(0, 2) + 1/6*EULER^2*ln(PI)*zeta(0, 3) 
        - 1/6*EULER^3*ln(PI)*zeta(0, 2) - 1/72*PI^2*ln(PI)*zeta(0, 3) 
        - 1/4*EULER^2*ln(2)^2*zeta(0, 2) + 1/48*PI^2*ln(2)^2*zeta(0, 2) 
        - 1/3*ln(PI)*ln(2)^2*zeta(3) + 1/6*ln(PI)*ln(2)^2*zeta(0, 3) 
        - 1/6*ln(PI)*ln(2)^3*zeta(0, 2) - 1/3*ln(PI)^2*ln(2)*zeta(3) 
        + 1/6*ln(PI)^2*ln(2)*zeta(0, 3) - 1/6*ln(PI)^3*ln(2)*zeta(0, 2) 
        + 1/72*EULER*PI^2*ln(PI)^3 + 1/96*EULER^2*PI^2*ln(2)^2 
        + 1/24*EULER*PI^2*ln(PI)*zeta(0, 2) - 1/2*EULER*ln(PI)*ln(2)^2*zeta(0, 2) 
        - 1/2*EULER*ln(PI)^2*ln(2)*zeta(0, 2) - 1/2*EULER^2*ln(PI)*ln(2)*zeta(0, 2) 
        + 1/24*PI^2*ln(PI)*ln(2)*zeta(0, 2) + 1/24*EULER*PI^2*ln(PI)*ln(2)^2 
        + 1/24*EULER*PI^2*ln(PI)^2*ln(2) + 1/48*EULER^2*PI^2*ln(PI)*ln(2) 
        + 1/24*EULER*PI^2*ln(2)*zeta(0, 2) - 1/3*EULER*ln(PI)*ln(2)*zeta(3) 
        + 1/3*EULER*ln(PI)*ln(2)*zeta(0, 3);
        // no break, we need to proceed!
---------------    */
    of 6 do
       t[4]:= 1/5*zeta(5) - 1/72*PI^2*zeta(3) - 1/72*PI^2*zeta(0, 3)
            - 1/12*ln(PI)*zeta(0, 4) + 1/120*EULER^5 - 1/6*ln(2)^2*zeta(3) 
            + 1/6*ln(2)^2*zeta(0, 3) - 1/6*ln(2)^3*zeta(0, 2) 
            - 1/144*EULER^3*PI^2 - 1/8*EULER*ln(PI)^4 - 1/30*ln(2)^5 
            - 1/6*EULER^2*ln(2)^3 - 1/12*EULER^3*ln(2)^2 + 1/72*PI^2*ln(2)^3 
            - 1/6*ln(PI)*ln(2)^4 - 1/6*ln(PI)^4*ln(2) - 1/6*ln(PI)^2*zeta(3) 
             + 1/6*ln(PI)^2*zeta(0, 3) - 1/6*ln(PI)^3*zeta(0, 2) 
            - 1/30*ln(PI)^5 - 1/12*EULER*zeta(0, 4) - 1/6*EULER^2*ln(PI)^3 
            - 1/12*EULER^3*ln(PI)^2 + 1/72*PI^2*ln(PI)^3 
            - 1/12*ln(2)*zeta(0, 4) - 1/3*ln(PI)^2*ln(2)^3 
            - 1/3*ln(PI)^3*ln(2)^2 - 1/3*zeta(3)*zeta(0, 2) - 1/640*EULER*PI^4 
            - 1/8*EULER*ln(2)^4 + 1/60*zeta(0, 5) + 1/6*EULER^2*zeta(3) 
            + 1/6*EULER^2*zeta(0, 3) - 1/6*EULER^3*zeta(0, 2) 
            + 1/3*EULER*ln(2)*zeta(0, 3) - 3/4*EULER*ln(PI)^2*ln(2)^2 
            - 1/2*EULER^2*ln(PI)*ln(2)^2 - 1/2*EULER^2*ln(PI)^2*ln(2) 
            + 1/24*PI^2*ln(PI)*ln(2)^2 + 1/24*PI^2*ln(PI)^2*ln(2) 
            + 1/24*EULER*PI^2*zeta(0, 2) + 1/3*EULER*ln(PI)*zeta(0, 3) 
            - 1/2*EULER*ln(2)^2*zeta(0, 2) - 1/2*EULER^2*ln(2)*zeta(0, 2) 
            + 1/24*PI^2*ln(2)*zeta(0, 2) - 1/3*ln(PI)*ln(2)*zeta(3)
            + 1/3*ln(PI)*ln(2)*zeta(0, 3) + 1/48*EULER*PI^2*ln(2)^2 
            - 1/2*EULER*ln(PI)*ln(2)^3 - 1/2*EULER*ln(PI)^3*ln(2) 
            - 1/6*EULER^3*ln(PI)*ln(2) - 1/2*EULER*ln(PI)^2*zeta(0, 2) 
            - 1/2*EULER^2*ln(PI)*zeta(0, 2) + 1/24*PI^2*ln(PI)*zeta(0, 2) 
            - 1/2*ln(PI)*ln(2)^2*zeta(0, 2) - 1/2*ln(PI)^2*ln(2)*zeta(0, 2) 
            + 1/48*EULER*PI^2*ln(PI)^2 - EULER*ln(PI)*ln(2)*zeta(0, 2)
            + 1/24*EULER*PI^2*ln(PI)*ln(2);
        // no break, we need to proceed!
    of 5 do // 1/x + EULER + x*(...) + x^2*(..) +  O(x^4)
       t[3]:= 1/24*PI^2*zeta(0, 2) + 1/3*ln(PI)*zeta(0, 3) + 1/24*EULER^4 
           - 1/2*ln(2)^2*zeta(0, 2) - 1/640*PI^4 - 1/48*EULER^2*PI^2 
           - 1/3*EULER*ln(PI)^3 - 1/8*ln(2)^4 - 1/4*EULER^2*ln(2)^2 
           + 1/48*PI^2*ln(2)^2 - 1/2*ln(PI)*ln(2)^3 - 1/2*ln(PI)^3*ln(2) 
           - 1/2*ln(PI)^2*zeta(0, 2) - 1/8*ln(PI)^4 + 1/3*EULER*zeta(3) 
           + 1/3*EULER*zeta(0, 3) - 1/4*EULER^2*ln(PI)^2 + 1/48*PI^2*ln(PI)^2
           + 1/3*ln(2)*zeta(0, 3) - 3/4*ln(PI)^2*ln(2)^2 - 1/3*EULER*ln(2)^3 
           - EULER*ln(PI)*ln(2)^2 - EULER*ln(PI)^2*ln(2)
           - 1/2*EULER^2*ln(PI)*ln(2) + 1/24*PI^2*ln(PI)*ln(2)
           - 1/12*zeta(0, 4) - 1/2*EULER^2*zeta(0, 2) - EULER*ln(2)*zeta(0, 2)
           - EULER*ln(PI)*zeta(0, 2) - ln(PI)*ln(2)*zeta(0, 2):
       // no break, we need to proceed!
    of 4 do // 1/x + EULER + x*(...) + x^2*(..) +  O(x^3)
       t[2]:= 1/3*zeta(3) - ln(PI)*zeta(0, 2) + 1/6*EULER^3 - 1/2*EULER*ln(PI)^2 
            - 1/3*ln(2)^3 - ln(PI)*ln(2)^2 - ln(PI)^2*ln(2) - 1/3*ln(PI)^3 
            - EULER*zeta(0, 2) - ln(2)*zeta(0, 2) - 1/24*EULER*PI^2
            - 1/2*EULER*ln(2)^2 + 1/3*zeta(0, 3) - EULER*ln(PI)*ln(2);
       // no break, we need to proceed!
    of 3 do // 1/x + EULER + x*(...) +  O(x^2)
       t[1]:=  1/2*EULER^2 - ln(PI)*ln(2) - 1/24*PI^2 
             - 1/2*ln(2)^2 - 1/2*ln(PI)^2 - zeta(0, 2);
       // no break, we need to proceed!
    of 2 do // 1/x + EULER + O(x)
       t[0] := EULER;
       // no break, we need to proceed!
    of 1 do // 1/x + O(1)
       t[-1] := 1:
       //------------------------------------
       // Now, create the whole series from 
       // all the coefficients defined above:
       //------------------------------------
       t := Series::Puiseux::create(1, -1-m, n-1-m,
                                    [binomial(k,m)*m!*t[k] $ k = -1..n-2],
                                    x, 0, dir);
       return(t);
    otherwise
       // For generic n > 5, use zeta(s) = 2^s*PI^(s-1)*sin(1/2*PI*s)*zeta(1-s)*gamma(1-s).
       // Note, that zeta(1 - s) will be expanded successfully  around 
       // s = 1 via Series::Unknown. This, however, is extremely expensive!
       t:= extsubsop(series(2^x*PI^(x-1)*sin(PI*x/2)*zeta(1-x)*gamma(1-x), 
                            x=1, max(n,2), dir), 6 = (x=0));

       // If m is a natural number, we may
       // return(diff(t, x $ m)
       // However, if m is symbolic, we need to extract the
       // coefficients and multiply them by binomial(k, m)*m!
       // The following code works both for integers m as
       // well as for symbolic m:

       if iszero(m) then
          return(t);
       end_if;

       t:= [t::dom::coeff(t)]: // list of coefficients 
                               // of series(zeta(1 + x, 0), x = 0, n)
       // convert the list to a table 
       t:= table(k-2 = t[k] $ k = 1..nops(t));
       // now we can proceed as above:
       t := Series::Puiseux::create(1, -1-m, n-1-m,
                                    [binomial(k,m)*m!*t[k] $ k = -1..n-2],
                                    x, 0, dir);
       return(t);
    end_case;
  end_if;    

  // recursively expand the argument
  t := Series::series(f, x, n, dir, opt);

  if dir <> Undirected then // directional expansion
    l := limit(f,x,dir);
    // expansion around infinity not yet implemented
    if l = undefined or has(l, infinity) then
      return(FAIL);
    end_if
  elif domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then // order too small
      l := FAIL;
    elif d >= 0 then
      l := coeff(t, x, 0)
    else // ldegree(t) < 0
      // expansion around infinity not yet implemented
      return(FAIL);
    end_if
  else
    l := FAIL
  end_if;

  if l = 1 then
    if n=1 then n:= 2: end_if; // catch invalid compositions (cf bug 844) ?!
    if traperror((t:= series(zeta(x, m), x=1, n, dir) @ t)) <> 0 then
      Series::error("order too small")
    else
      return(t)
    end_if
  end_if;

  Series::unknown(zeta(f, m),x,n,dir)

end_proc:
