//
/* combineSinCos.mu
 * 06.12.2004 rensmann
 *
 * Erweitert den Funktionsumfang von combine( Expression, sincos )
 * Ersetzt wird sin(2z) / cos(z) => 2sin(z), sin(z)*cos(z) = sin(2z) / 2
 */

Simplify::combineSinCos :=
proc( a )
	local L, i, j, multIndets, rem;
begin
	multIndets := proc( a:"_mult" )
		local result, i;
	begin
		result := {}:
		for i in [op(a)] do
			if testtype( i, "_power" ) and testtype( op(i,2), Type::PosInt ) then
				result := result union { op(i,1) }
			else
				result := result union { i };
			end_if;
		end_for;
		return( result );
	end;

	rem := 1;

	case type( a )
		of "_mult" do
			// sin(2z) / cos(z) -> 2sin(z)
			L := map( [ select( op(a), X->( testtype(X,"_power") and testtype( op(X,2), Type::NegInt ) and  testtype( op(X,1), "cos" ) ) ) ], X->[ op(X, [1,1]), -op(X,2) ] );
			for i in L do
				j := i[2];
				while j>0 and contains( multIndets( a ), sin(2*i[1] ) ) do
					a := a * cos( i[1] ) / sin( 2*i[1] ) * 2 *sin( i[1] );
					j := j-1;
				end_while;
			end_for;

			// sin(z)*cos(z) = sin(2z) / 2
			L := map( { select( op(a), X->( testtype(X,"_power") and testtype( op(X,2), Type::Integer ) and  testtype( op(X,1), "sin" ) ) ) }, X->[ op(X, [1,1]), op(X,2) ] )
				intersect map( { select( op(a), X->( testtype(X,"_power") and testtype( op(X,2), Type::Integer ) and  testtype( op(X,1), "cos" ) ) ) }, X->[ op(X, [1,1]), op(X,2) ] );
			if L <> {} then
				a := a / _mult( op( map( [op(L)], X->_power(sin(X[1])*cos(X[1]), X[2] ) ) ) );
				rem := rem * _mult( op( map( [op(L)], X->(_power(1/2*sin(2*X[1]), X[2] ) ) )) );
			end_if;

			break;
	end_case:

	combine( a, sincos ) * rem
end:
