/*

makes x+c in A into x in A-c and c*x in A into x in (1/c)*A

*/

Simplify::inRemoveConst:=
proc(X: "_in")
  local l, r, s;
begin
  [l, r]:= [op(X)];
  case type(l)
    of "_plus" do
      s:= select(l, testtype, Type::Constant);
      if s<>0 then
        return(l-s in r-s)
      end_if;
      break
    of "_mult" do
      s:= select(l, testtype, Type::Constant);
      if s<>1 then
        return(l/s in r/s)
      end_if;
      break
  end_case;

  X
end_proc:
