// 

// 06/2003, bij, stefanw
//

// special simplification method by Francois Maltey

Simplify::radsimpMatchSqrt:=
  proc(e: "_power")
    local br, br1;
  begin
    radsimp; // initialize radsimp to provide internal functions
    if (br:=stdlib::radsimp_matchsqrt (e))<> FAIL
      and (br1 := stdlib::radsimp_match2sqrt (br)) <> FAIL
      // returns a b r
      and is(br1[1] > 0) = TRUE
      and is(br1[2] > 0) = TRUE
      and is((br := br1[1]^2 - br1[2]^2 * br1[3]) >= 0) = TRUE
      // Delta here a^2 - b^2 r
      and ((type ((br := sqrt (br))) = DOM_INT) or (type (br) = DOM_RAT)) then
      return (sqrt ((br1[1] + br) / 2) + sqrt ((br1[1] - br) / 2)) ;
      // end of 1st case : sqrt x + sqrt y
      // beginning of 2nd case : sqrt x - sqrt y
    elif (br:=stdlib::radsimp_matchsqrt (e))<> FAIL
      and (br1 := stdlib::radsimp_match2sqrt (br)) <> FAIL // returns a b r
      and is(br1[1] > 0) = TRUE
      and is(br1[2] < 0) = TRUE
      and is((br := br1[1]^2 - br1[2]^2 * br1[3]) >= 0) = TRUE
      // here a^2 - b^2 r
      and ((type ((br := sqrt (br))) = DOM_INT) or (type (br) = DOM_RAT)) then
      return (sqrt ((br1[1] + br) / 2) - sqrt ((br1[1] - br) / 2)) ;
      // end of 2nd case : sqrt x - sqrt y
    end_if;
    
    // no match
    e
  end_proc:
