// 

// 06/2003, bij, stefanw
//

Simplify::ratExponent:=
proc(e:"_power")
  local a, b, p, l;
begin
  [a, b] := [op(e)];


  if domtype(b) <> DOM_RAT then
    return(e)
  end_if;

  // try whether a^(p/q) can be expressed as (a^p)^(1/q)
  if specfunc::abs(op(b, 1)) > 1 and specfunc::abs(op(b, 1)) < 64 and
    testtype(a, Type::Constant) and
    is(arg(a) < PI/abs(op(b, 1)) and arg(a) > -PI/abs(op(b, 1))) = TRUE
    then

    l:= expand(a ^ (op(b, 1)));
    if property::complexity(l) <= property::complexity(a) then
      return(l^(1/op(b, 2)))
    end_if
  end_if;
  
  
  // special case: (x^2)^(1/2) = x*sign(x) for real x
  if type(a) = "_power" and (b = 1/2 or b = -1/2) and is((p:= op(a, 1)^(op(a, 2) * b)) in R_, Goal = TRUE) then
    return(p*sign(p))
  end_if;  

  e
end_proc:
  
