// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of any type
//   must be a list of procedures or rules

Simplify::All :=
  proc(EXPR): DOM_LIST
    local inds, sl, res: DOM_LIST, testFrac;
  begin

    if contains({DOM_LIST, DOM_SET}, domtype(EXPR)) then
      // no rules, subexpression step only
      // we must *not* map Simplify (with all options) to the elements, since
      // we would not be able to handle e.g. the option All
      return([])
    end_if;

    // use lazy evaluation: sl will point to the "Simplify" slot,
    // or, if that one does not exist, to the "simplify" slot
    if (sl:= EXPR::dom::Simplify) <> FAIL or
      (sl:= EXPR::dom::simplify) <> FAIL then
      if domtype(sl) <> DOM_LIST then
        return([Rule(sl, {}, table("Default" = 0.0))])
      else
        return(sl)
      end_if
    else

      // overloading by function attribute
      // in case of IgnoreAnalyticConstraints, we do this by the rules from the other rule base
      if domtype(eval(op(EXPR, 0))) = DOM_FUNC_ENV then
        if (sl:= slot(eval(op(EXPR, 0)), "Simplify")) <> FAIL then
          if domtype(sl) <> DOM_LIST then
            // do only this step
            return([Rule(Simplify::overload, {}, table("Default" = 0.0, "IgnoreAnalyticConstraints" = 10000.0 ))])
          else
            res:= sl
          end_if
        elif (sl:= slot(eval(op(EXPR, 0)), "simplify")) <> FAIL then
          res:= [Rule(Simplify::overload, {}, table("Default" = 0.0, "IgnoreAnalyticConstraints" = 10000.0 ))]
        else
          res:= []
        end_if
      else
        res:= []
      end_if;

      inds:= indets(EXPR, All);

      // normal is only needed if we have a sum/product of at least one fraction
      testFrac := proc(EXPR)
        local res;
      begin
        if testtype(EXPR, "_power") and testtype(op(EXPR,2), Type::NegInt) then
          return(UNKNOWN);
        end_if;
        if domtype(EXPR)=DOM_EXPR then
          res := _or(op(map([op(EXPR)], testFrac)));
        else
          res := FALSE;
        end_if;
        if (testtype(EXPR, "_plus") or testtype(EXPR, "_mult")) and res=UNKNOWN then
          res := TRUE;
        end_if;
        return(res);
      end_proc;

      res := res.
      [
         // in case of IgnoreAnalyticConstraints, we do this by the rules from the other rule base
       Rule(Simplify::expand, {}, table("Default" = 0.8,
                                        "IgnoreAnalyticConstraints" = 0.8)
            ),


       if testtype(EXPR, Type::Arithmetical) and testFrac(EXPR)=TRUE then
         if testtype(EXPR, "_mult") then
           Rule(X -> normal(X),  {}, table("Default" = 1.4))
         else
           Rule(X -> normal(X),  {}, table("Default" = 1.85))
         end_if
       end_if,


       if testtype(EXPR, Type::Constant) and has(EXPR, I) then
         Rule(X -> expr(rectform(X)), {}, table("Default" = 1.1))
       end_if


//       if inds intersect {hold(sin), hold(cos)} <> {} then
//         Rule(X -> combine(X, sincos), {}, table("Default" = 0.9))
//       end_if

       ];
//       res := res.map( select( map( select( property::showprops( property::freeIndets(EXPR) ), testtype, "_equal" ), X->{ op(X) } ), contains, EXPR ), X -> Rule( fp::unapply( op(X minus {EXPR}), Y ), {}, table("Default"=0.5)) );
       res := res.[op(map(_union(op(map(
         select(property::showprops(property::freeIndets(EXPR)), testtype, "_equal"),
         eq -> {subsex(EXPR, eq), subsex(EXPR, op(eq,2)=op(eq,1))} minus {EXPR}))),
         s -> Rule(EXPR, s, {}, table("Default" = 0.5))))];

       res;
    end_if
  end_proc:
