// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of type '_plus'
//   must be a list of procedures or rules

Simplify::_plus :=
proc(S)
  local inds, ratinds, r, n, frequency;
begin
  // local method frequency
  frequency:= 
  proc(u)
  begin
    nops(select([op(S)], has, u))
  end_proc;


  if not testtype(S, Type::Arithmetical) then 
    // this can happen - hold(_plus)(some_nonsense) or _plus(a[i] $i=1..n) for symbolic n
    return([])
  end_if;

  inds:= indets(S, All);
  ratinds:= indets(S, RatExpr);
  
  [
//   if contains(inds, hold(sin)) or contains(inds, hold(cos)) then
//	if nops( select( (op(S), map( select( op(S), testtype, "_mult" ), op)), X->testtype(X, "sin") or testtype(X, "cos") ) ) > 1 then
	if inds intersect {hold(sin), hold(cos)} <> {} then
      Rule(X -> combine(X, sincos), {}, table("Default"=0.9))
   else
     null()
   end_if,

   if contains(inds, hold(arctan)) then
      Rule(X -> combine(X, arctan), {}, table("Default"=0.9))
   end_if,
   
// the following rules have low priority if we can do combine with IgnoreAnalyticConstraints
   if contains(inds, hold(ln)) then
      Rule(X -> combine(X, ln), {}, table( "Default"=0.9,
                                           "IgnoreAnalyticConstraints" = 3.0 ) )
   end_if,

    if contains(inds, hold(log)) then
      Rule(X -> combine(X, log), {}, table( "Default"=0.9, "IgnoreAnalyticConstraints" = 3.0  ) )
    end_if,

   if contains(inds, hold(exp)) then
      Rule(X -> combine(X, exp), {}, table("Default"=0.9, "IgnoreAnalyticConstraints" = 3.0 ))
   end_if,

   if nops(select(misc::subExpressions(S, {"_power"}), X -> type(op(X, 2)) = DOM_RAT)) <> 0 then 
     Rule(Simplify::fractionalPowers, {}, table("Default" = 1.02))
   end_if,


   // collect-rules
   (if (n:= frequency(r)) >= 2 then   
     Rule(subs(X -> collect(X, #ind), #ind = r), {}, table("Default" = max(0.05, 1.3 - 0.06*n)))
   end_if) $r in select(ratinds, X -> contains({"igamma", "gamma"}, type(X))), 

   Rule(Simplify::sqrfreeFactor, {}, table("Default" = 1.05)),

   Rule(X -> maprat(X, expr@factor), {}, table("Default" = 1.3)),

   // Rule(X -> expr(factor(X)), {}, table("Default" = 1.3)),

   null()

   ]

end_proc:

