// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of type 'tan'
//   must be a list of procedures or rules

Simplify::tan :=
proc(EXPR: "tan")
  local x, q;
  option escape;
begin
  x:= op(EXPR);

  [
   // half-angle formulas
   if
     type((q:= icontent(op(rationalize(x), 1)))) = DOM_RAT and
     op(q, 2) mod 2 = 0 then
     Rule(X -> sin(2*op(X, 1))/(1 + cos(2*op(X, 1))) ),
     Rule(X -> (1 - cos(2*op(X, 1)))/sin(2*op(X, 1))),
     Rule(X -> tan(2*op(X, 1)) * sin(2*op(X, 1))/
          (tan(2*op(X, 1)) + sin(2*op(X, 1))))
   elif type(q) = DOM_INT and specfunc::abs(q) >1 then
     Rule(X -> subs(expand(tan(q*`#Y`)), `#Y` = op(X, 1)/q, EvalChanges))
   else
     null()
   end_if,

   Rule(tan(`#x`), 1/cot(`#x`)),

   Rule(tan(jacobiAM(`#a`,`#b`)), jacobiSC(`#a`,`#b`)),
   
   // A couple of identities from functions.wolfram.com
   Rule(tan(arcsin(`#x`)), `#x`/sqrt(1-`#x`^2)),
   Rule(tan(arccos(`#x`)), sqrt(1-`#x`^2)/`#x`),
   Rule(tan(arctan(`#x`)), `#x`),
   Rule(tan(arccot(`#x`)), 1/`#x`),
   Rule(tan(arccsc(`#x`)), sqrt(`#x`^2)/(`#x`*sqrt(`#x`^2-1))),
   Rule(tan(arcsec(`#x`)), `#x`*sqrt(1-1/`#x`^2)),
   Rule(tan(I*arcsinh(`#x`)), I*`#x`/sqrt(1+`#x`^2)),
   Rule(tan(I*arccosh(`#x`)), I/`#x`*sqrt(`#x`-1)*sqrt(`#x`+1)),
   Rule(tan(I*arctanh(`#x`)), I*`#x`),
   Rule(tan(I*arccoth(`#x`)), I/`#x`),
   Rule(tan(I*arccsch(`#x`)), I*sqrt(-`#x`^2)/(`#x`*sqrt(-1-`#x`^2))),
   Rule(tan(I*arcsech(`#x`)), I*sqrt((1-`#x`)/(1+`#x`))*(1+`#x`)),
   Rule(tan(arcsin(`#x`)/2), (1-sqrt(1-`#x`^2))/`#x`),
   Rule(tan(arccos(`#x`)/2), sqrt(1-`#x`)/sqrt(1+`#x`)),
   Rule(tan(arctan(`#x`)/2), (sqrt(`#x`^2+1)-1)/`#x`),
   Rule(tan(arccot(`#x`)/2), `#x`*(sqrt(1+1/`#x`^2)-1)),
   Rule(tan(arccsc(`#x`)/2), `#x`*(1-sqrt(1-1/`#x`^2))),
   Rule(tan(arcsec(`#x`)/2), sqrt(`#x`-1)*sqrt(-`#x`)/(sqrt(-`#x`-1)*sqrt(`#x`))),
   Rule(tan(I/2*arcsinh(`#x`)), I/`#x`*(sqrt(1+`#x`^2)-1)),
   Rule(tan(I/2*arccosh(`#x`)), I*sqrt((`#x`-1)/(`#x`+1))),
   Rule(tan(I/2*arctanh(`#x`)), I/`#x`*(1-sqrt(1-`#x`^2))),
   Rule(tan(I/2*arccoth(`#x`)), I*`#x`/sqrt(`#x`^2)*(sqrt(`#x`^2)-sqrt(`#x`^2-1))),
   Rule(tan(I/2*arccsch(`#x`)), I*`#x`*(sqrt(1+1/`#x`^2)-1)),
   Rule(tan(I/2*arcsech(`#x`)), I*sqrt((1-`#x`)/(1+`#x`))),
   
   Rule(tan(`#n`*arctan(`#x`)), -I*((I*`#x`+1)^`#n`-(1-I*`#x`)^`#n`)/
                                   ((I*`#x`+1)^`#n`+(1-I*`#x`)^`#n`),
        {`#n`->testtype(`#n`, Type::PosInt)}),
   Rule(tan(`#x`/2), csc(`#x`)-cot(`#x`))
   ]
end_proc:

