// utility called below:
Simplify::besselComplexity:= proc(X)
  local c, v, x, n, more;
begin
  c:= 500:  // baselevel: bessels are bad!
  [v, x]:= [op(X)];  // X = bessel{JY}(v, x)
  case type(X)
  of "besselJ" do more:= 0; break;    // We can rewrite all 
  of "besselI" do more:= 1000; break; // bessels either to 
  of "besselY" do more:= 2000; break; // besselJ (preferred)
  of "besselK" do more:= 2000; break; // or to besselI.
  otherwise
      more:= 0;
  end_case;
  c:= c + 2*Simplify::complexity(v);
  c:= c + 2*Simplify::complexity(x);
  [v, n]:= besselJ::split_index(v);
  if n <= -1 or n > 1 then
     c:= c + 1200;
  end_if:
  return(c + more);
end_proc:

//   
Simplify::defaultOperatorTable:=
table(
      "Default"   = 1000, // = unknown

      DOM_FAIL    = 0, // nothing
      "Atomic"    = 1, // non -expressions
      DOM_IDENT   = 50,
      DOM_INT     = (q -> specfunc::ln(1 + specfunc::abs(q)/5 + (2 - specfunc::sign(q))/10)),
      DOM_RAT     = (q -> 2.5 + (2 - specfunc::sign(q))/10
                            + .8*specfunc::ln(specfunc::abs(op(q, 1)))
                            + 1.2*specfunc::ln(specfunc::abs(op(q, 2)))),
      DOM_FLOAT   = 2,

      "piecewise"   = proc(pw)
                      local cond, exprs, ops;
                      begin
                        ops:= [op(pw)];
                        cond:= map(ops, op, 1);
                        exprs:= map(ops, op, 2);
                        50 + 2* Simplify::complexity(cond) +
                                Simplify::complexity(exprs)
                    end_proc,


      "_index"    = 2,

      "_plus"     = proc(EXPR)
                      local k;
                    begin
                      2 +
                      specfunc::ln(1 + nops(EXPR))
                        *_plus(
                               if type(op(EXPR, k)) = "_mult" and
                                 op(EXPR, [k, nops(op(EXPR, k))]) = -1 then
                                 // negate, no problem
                                 0.5 + Simplify::complexity(-op(EXPR, k))
                               else
                                 Simplify::complexity(op(EXPR, k))
                               end_if
                               $ k=1..nops(EXPR))
                    end_proc,
      "_mult"     = proc(EXPR)
                      local C, k;
                    begin
                      C:= op(EXPR, nops(EXPR));
                      if C = -1 then
                        // negate
                        3 + Simplify::complexity(-EXPR)
                      else
                        3 + _plus(1.1*Simplify::complexity(op(EXPR, k))
                                  $ k=1..nops(EXPR))
                      end_if
                    end_proc,
      "_power"    = proc(EXPR)
                      local bas, expo, n;
                    begin
                      [bas, expo]:= [op(EXPR)];
                      if domtype(expo) = DOM_INT then
                        if expo < 0 then
                          // fraction
                          2.4*Simplify::complexity(1/EXPR)
                        else
                          // no penalty for base, slight penalty for exponent
                          10 + Simplify::complexity(bas) +
                          2*Simplify::complexity(expo)
                        end_if
                      elif domtype(expo) = DOM_RAT then
                        if domtype(bas) = DOM_INT then
                          5 + 3.0*Simplify::complexity(bas) +
                          Simplify::complexity(expo)
                        else
                          10 + 2.5*Simplify::complexity(bas) +
                          3.5*Simplify::complexity(expo)
                        end_if
                      elif type(expo) = "_mult" and type((n:= op(expo, nops(expo)))) = DOM_INT then
                        55 + 1.8*Simplify::complexity(bas) +
                        2*Simplify::complexity(expo/n) +
                        Simplify::complexity(n)
                      else
                        55 + 1.8*Simplify::complexity(bas) +
                        2*Simplify::complexity(expo)
                      end_if
                    end_proc,
      // make surd slightly worse than _power
      "surd"      = proc(EXPR)
                    begin
				if domtype(op(EXPR, 2)) = DOM_INT then
				  50 + 2.5*Simplify::complexity(op(EXPR, 1)) +
                          3.5*Simplify::complexity(op(EXPR, 2))
                        else
				  100 + 1.8*Simplify::complexity(op(EXPR, 1)) +
                          2*Simplify::complexity(op(EXPR, 2))
                        end_if
                    end_proc,
      "I"         = 100, // special case
      "exp"       = [50, 2],
      "ln"        = [55, 2],
      "log"       = [70, 2],
      "sin"       = [60, 2],
      "cos"       = [60, 2],
      "tan"       = [70, 2],
      "cot"       = [75, 2],
      "Re"        = 100,
      "Im"        = 100,
      "arcsin"    = [100, 2],
      "arccos"    = [100, 2],
      "arctan"    = [150, 2],
      "arccot"    = [180, 2],
      "sinh"      = [80, 2],
      "cosh"      = [80, 2],
      "tanh"      = [120, 2],
      "coth"      = [150, 2],
      "arcsinh"   = [150, 2],
      "arccosh"   = [150, 2],
      "arctanh"   = [180, 2],
      "arccoth"   = [200, 2],

      "fact"      = [50, 2],
      "fact2"     = [150, 2],
      "gamma"     = [500, 2],
      "igamma"    = [600, 2],
      "pochhammer"= [300, 2],

      "whittakerM" = [2000, 4],
      "whittakerW" = [2000, 4],
      "kummerU"    = [1800, 4],

      "hypergeom" = (X -> 10000 + 300*(nops(op(X, 1))+nops(op(X,2))) +
                          2 * _plus(op(map([op(X)], Simplify::complexity)))),
      "meijerG" = (X -> 10^6 + 500*(nops(op(X, [1,1]))+nops(op(X,[1,2])) + nops(op(X, [2,1]))+nops(op(X,[2,2]))) +
                          3 * _plus(Simplify::complexity(op(X,3)))),


      "fresnelS" = [300, 30],
      "fresnelC" = [300, 30],

      "ellipticCE" = [600, 2],
      "ellipticCK" = [600, 2],
      "ellipticCPi" = [600, 2],
      "ellipticE" = [600, 2],
      "ellipticF" = [600, 2],
      "ellipticK" = [600, 2],
      "ellipticNome" = [600, 2],
      "ellipticPi" = [600, 2],

      "abs"       = [20, 1.2],
      "sign"      = [30, 1.2],
      "heaviside" = [60, 1.2],

      "arg"       = [80, 1.2],

      "trunc"     = [100, 2],
      "floor"     = [95, 2],
      "round"     = [100, 2],

      // these functions use recurrence relations,
      // so something like besselJ(v+3, x) is "more complicated" than besselJ(v, x)
      "besselJ" = Simplify::besselComplexity,
      "besselI" = Simplify::besselComplexity,
      "besselY" = Simplify::besselComplexity,
      "besselK" = Simplify::besselComplexity,


      // operations on functions like limit, int, sum
      "int"       = [5000, 3],
      "limit"     = [4000, 3],
      "sum"       = [5000, 3],

      // operators used for forming boolean expressions
      "_equal"    = 3,
      "_unequal"  = 4,
      "_leequal"  = 5,
      "_less"     = 5,
      "_not"      = 10,
      "_and"      = 15,
      "_or"       = 15,
      "_in"       = [20, 1.2],

      // operators for set-theoretic expressions

      "_union"    = [15, 1.2],
      "_intersect"= [15, 1.2],
      "_minus"    = [15, 1.2],
      "Dom::Matrix()" = proc( EXPR )
                      local dim, i, j;
                    begin
                      dim := linalg::matdim( EXPR );
                      _plus( op( map( [ EXPR[i,j] $ i=1..dim[1] $ j=1..dim[2] ], Simplify::complexity ) ) );
                    end_proc,

      "Dom::ImageSet" = ( X->1.2*Simplify::complexity( op(X,1) ) ),
      "solvelib::VectorImageSet" = ( X->1.2*Simplify::complexity( op(X,1) ) ),

      // units
      "unit"        = 100
):

// overloading domains
rectform::complexity:=
proc(rf: rectform)
begin
  Simplify::complexity(expr(rf))
end_proc:

undefined::dom::complexity:= 1:

Simplify::createValuation:=
  proc(T = Simplify::defaultOperatorTable/*, DepthPenalty = 1*/)
    option escape;
    local f: DOM_PROC;
  begin

    f :=
    // return value:
    proc(EXPR = FAIL, depth = 0)
      option remember;
      local i:DOM_INT;
      name Simplify::complexity;
    begin
      // special case for complex numbers: regard them as expressions
      case domtype(EXPR)
        of DOM_COMPLEX do
          if EXPR = I then
            if contains(T, "I") then
              T["I"]
            else
              T["Atomic"]
            end_if;
          elif iszero(op(EXPR, 1)) then
            T["_mult"]([op(EXPR, 2), I])
          else
            T["_plus"](op(EXPR, 1)) + f(op(EXPR, 2) * I, depth + 1)
          end_if;
          break
        of Factored do
        of DOM_SET do
        of DOM_LIST do
          1 + _plus(f(op(EXPR, i), depth + 1) $i=1..nops(EXPR));
          break

        of DOM_EXPR do
          if contains(T, type(EXPR)) then
            if contains({DOM_PROC, DOM_FUNC_ENV}, domtype(T[type(EXPR)])) then
              T[type(EXPR)](EXPR)
            elif domtype(T[type(EXPR)]) = DOM_LIST and
              nops(T[type(expr)])=2 then
              T[type(EXPR)][1] +
              T[type(EXPR)][2]*_plus(f(op(EXPR, i), depth + 1) $i=1..nops(EXPR))
            else
              T[type(EXPR)] + _plus(f(op(EXPR, i), depth + 1) $i=1..nops(EXPR))
            end_if
          else
            T["Default"] + _plus(f(op(EXPR, i), depth + 1) $i=1..nops(EXPR))
          end_if;
          break

        otherwise
          if contains(T, type(EXPR)) then
            T[type(EXPR)](EXPR)
          elif contains(T, expr2text(type(EXPR))) then
            T[expr2text(type(EXPR))](EXPR)
          elif EXPR::dom::complexity <> FAIL then
            EXPR::dom::complexity(EXPR)
          else
            T["Atomic"]
          end_if
      end_case

      //* DepthPenalty^depth
    end_proc;

  end_proc:

// default
Simplify::complexity := Simplify::createValuation():

