

domain solvelib::VectorImageSet
  category Cat::Set;
  inherits Dom::ImageSet;
  
    allowVectors:= TRUE;


    _subset:= FAIL;
    
    inhomogleft_minus:=
    table(
          DOM_SET =
          proc(vset, S: DOM_SET)
          begin
            if S= {} then
              return(vset)
            end_if;
            FAIL
          end_proc,
          solvelib::cartesianPower =
          proc(vset, S)
          begin
            if op(S, 1) = C_ then
              return({})
            end_if;
            FAIL
          end_proc
          );


    inhomogright_minus:=
    table(
          DOM_SET =
          proc(S: DOM_SET, vset)
            local x, newS, unk, cond;
            save MAXEFFORT;
          begin
            newS:= unk := {};
            if nops(S) > 1 then
               MAXEFFORT:= MAXEFFORT/nops(S)
            end_if;
            if MAXEFFORT < 100 then
               return(FAIL)
            end_if;
            for x in S do
              case ((cond:= vset::dom::simpexIn(x, vset)))
                of TRUE do
                  // x has to be deleted, do nothing
                  break;
                of FALSE do
                  // x belongs to the result
                  newS:= newS union {x};
                  break
                otherwise
                  // the status of x remains unknown
                  unk:= unk union {[not cond, x]}
              end_case;
            end_for;
            if unk = {} then
              return(newS)
            end_if;

            if nops(unk) <= 4 then
              // expand in terms of piecewise
              unk:= map(unk, br -> [[br[1], {br[2]}], [not br[1], {}]]);
              unk:= map(unk, br -> piecewise(op(br)));
              newS:= newS union _union(op(unk));
              return(newS)
            end_if;
           
            unk:= map(unk, op, 2);
            if newS = {} then
              return(hold(_minus)(unk, vset))
            else
              return(hold(_union)(newS, hold(_minus)(unk, vset)))
            end_if
          end_proc
          );

    
    inhomog_union:=
    table(
          DOM_SET =
          proc(vset, S: DOM_SET)
          begin
            if S= {} then
              return(vset)
            end_if;
            FAIL
          end_proc,
          solvelib::cartesianPower =
          proc(vset, S)
          begin
            if op(S, 1) = C_ then
              return(S)
            end_if;
            FAIL
          end_proc
          );

    inhomog_intersect:=
    table(
          DOM_SET =
          proc(vset, S: DOM_SET)
            local newS, x, unk;
          begin
            newS:= {};
            unk:= {};
            for x in S do
              case vset::dom::simpexIn(x, vset)
                of FALSE do
                  // x has to be deleted, do nothing
                  break;
                of TRUE do
                  // x belongs to the result
                  newS:= newS union {x};
                  break
                otherwise
                  // the status of x remains unknown
                  unk:= unk union {x}
              end_case;
            end_for;
            if unk = {} then
              return(newS)
            elif newS = {} then
              return(hold(_intersect)(unk, vset))
            else
              return(hold(_union)(newS, hold(_intersect)(unk, vset)))
            end_if
          end_proc,

          // solvelib::cartesianPower: handled there
          

          DOM_EXPR =
          proc(vset, S: DOM_EXPR)
            local l1, l2;
          begin
            // try to express vset = A_1 x A_2 x ... and
            // S as B_1 x B_2 x ...
            // then return((A1 intersect B1) x (A2 intersect B2) x ...
            if (l1:= solvelib::splitVectorSet
                (vset, solvelib::dimension(vset))) <> FAIL and
              (l2:= solvelib::splitVectorSet
               (S, solvelib::dimension(S))) <> FAIL then
              solvelib::cartesianProduct(op(zip(l1, l2, _intersect)))
            else
              FAIL
            end_if
          end_proc
          );

    inhomog_plus:=
    table(
          DOM_SET =
          proc(vset, S: DOM_SET)
          begin
            // for each vector s in S and v = expr(vset), compute
            // {s+v; op(vset, 2) in op(vset, 3)} and take the union of all
            // these
            map(map(S, zip, expr(vset), _plus),
                solvelib::VectorImageSet, extop(vset, 2..3));
            _union(op(%))
          end_proc
          );

    // vectors cannot be multiplied
    inhomog_mult:= table();
    
    
    bin_minus:= 
    proc(A, B)
      local S, T, cmp, i;
    begin
      if A=B then return({}) end_if;

      if dom::bin_intersect(A, B) = {} then 
        return(A)
      end_if;     
 
      // write A = S1 x S2 X S3 ...
      // and   B = T1 x T2 x T3 ...
      if (S:= solvelib::splitVectorSet(A)) = FAIL or
         (T:= solvelib::splitVectorSet(B)) = FAIL then
         return(FAIL)
      end_if;
      cmp:= zip(S, T, _intersect);
      if contains(cmp, {}) > 0 then 
        return(A)
      end_if;
      // check at which index positions S_i = S_i intersect T_i; i.e.,  S_i \subset T_i
      // if there is more than one index position where this does not hold, we must give up
      cmp:= zip(cmp, S, bool@_equal):
      i:= contains(cmp, FALSE);
      if i=0 then
        // every Si is a subset of the corresponding Ti 
        // thus, the difference is empty
        return({})
      end_if;
      if contains(cmp, FALSE, i+1) = 0 then 
        S[i]:= S[i] minus T[i];
        return(solvelib::cartesianProduct(op(S)))
      end_if;  
     
      FAIL  
    end_proc;   
    
    bin_union:=
    proc(A, B)
      begin
        if A=B then
          A
        else
          FAIL
        end_if
    end_proc;

    /*
       bin_intersect(v, w) - compute v \cap w
       With
         v= {[v1, ..., vn]; x1 \in S_1, .., xk \in S_k}
       and
         w= {[w1,..., wn]; y1 \in T_1, .., yl \in T_l}

       that is, we have to solve
       {v1 = w1, ..., vn = wn} for x1, .., xk, y1,..,yl 

    */
    bin_intersect:=
    proc(v: dom, w:dom)
      local x, y, sol, var, X, S, T, i, n;
      save MAXEFFORT;
    begin
      if (n:= solvelib::dimension(v)) <> solvelib::dimension(w) then
        return({})
      end_if;

      S:= solvelib::splitVectorSet(v, n);
      if S<>FAIL then
        T:= solvelib::splitVectorSet(w, n);
        if T <> FAIL then
          // since v=S1 x .. x S_k and w=T1x..x Tk,
          // v intersect w = (S1 intersect T1) x ... x (Sk intersect Tk)
          assert(nops(S) = nops(T));
          return(solvelib::cartesianProduct
                 (solvelib::solve_intersect(S[i], T[i])
                  $i=1..nops(S)))
        end_if
      end_if;
      
      x:= v::dom::variables(v);
      y:= w::dom::variables(w);
      S:= v::dom::sets(v);
      T:= w::dom::sets(w);
      v:= expr(v);
      w:= expr(w);
      // handle alias - problem
      for var in {op(x)} intersect {op(y)} do
        X:= genident();
        y:= subs(y, var = X);
        w:= subs(w, var = X)
      end_for;

      
      for i from 1 to nops(x) do
        assumeAlso(x[i] in S[i])
      end_for;
      for i from 1 to nops(y) do
        assumeAlso(y[i] in T[i])
      end_for;
                   
      MAXEFFORT:= MAXEFFORT/3;
      sol:= solve(v = w, x.y, VectorFormat, IgnoreProperties);
      if sol = {} then
        return({})
      end_if;
     
      // sol:= sol intersect solvelib::cartesianProduct(op(S), op(T));
      
      X:= solvelib::splitVectorSet(solvelib::selectIndices
                                   (sol, [$1..nops(x)]), nops(x));
      if X = FAIL then
        FAIL
      else
        solvelib::VectorImageSet(v, x, zip(X, S, _intersect))
      end_if
    end_proc;


   
    /* substituteBySet(a, x, S)

       creates the set of all a that can be obtained by substituting some
       element of S for x

     */
    substituteBySet:=
    proc(a, x: DOM_LIST, S: dom)
      local i;
    begin
      if nops(x) <> solvelib::dimension(S) then
        error("dimensions do not match")
      end_if;
      dom::new(subs(a, x[i] = expr(S)[i] $i=1..nops(x)),
               dom::variables(S),
               dom::sets(S))
    end_proc;

    
    simpexIn:=
    proc(a, S: dom)
      local x, vars: DOM_LIST, eq, newx, sol, i;
    begin

      vars:= dom::variables(S);
      eq:= expr(S);
      for x in vars do
        if has(a, x) then
          // avoid alias - problem
          newx:= genident();
          eq:= subs(eq, x= newx);
          vars:= subs(vars, x = newx)
        end_if
      end_for;

      for i from 1 to nops(vars) do
        save vars[i];
        assume(vars[i] in S::dom::sets(S)[i])
      end_for;
        
      if indets(eq) minus Type::ConstantIdents minus {op(vars)} = {} then
        sol:= solve(zip(eq, a, _equal), vars, VectorFormat);
        return(not solvelib::isEmpty(sol))
      end_if;
  
      hold(_in)(a, S) // not yet implemented, would require an "exists"-
                        // quantifier
    end_proc;

    expr2text:=
    proc(x)
    begin
      if nops(dom::sets(x)) = 1 then
        hold(solvelib::VectorImageSet)(expr(x), dom::variables(x)[1], dom::sets(x)[1])
      else
        hold(solvelib::VectorImageSet)(expr(x), dom::variables(x), dom::sets(x))
      end_if
    end_proc;

    // treat vector image sets as objects that cannot be handled by hull
    hull:= hull(FAIL);
    

end_domain:
