// Methods for solving algebraic systems

// the function solvelib::algebraic (former interface function in 1.4)
// has been removed




/*--
	solvelib::solve_algebraic(sys, unk, options) solves the algebraic
	system 'sys' with respect to the unknowns 'unk' 
--*/

solvelib::solve_algebraic:=
proc(syss: DOM_LIST, unkk: DOM_LIST) 
local Factor, solve_algebraic_recursive: DOM_PROC, options;

begin
  options:= solvelib::getOptions(args(3..args(0)));
  

  Factor:=
  proc(f)
    option remember;
  begin
    factor(f)
  end_proc;

solve_algebraic_recursive:= 
proc(syss: DOM_LIST, unkk: DOM_LIST)
  local g, gb, sys, unk, dm, storeLeadingCoeffs: DOM_PROC,
  store: DOM_BOOL,
  lcoefflist: DOM_LIST, linear, lc, i, j, f, inds,
  indepSets, 
  monic, cond, dimen,
  solveIrreducibleFactor: DOM_PROC;
  
begin

  lcoefflist:= [];
  
  // procedure storeLeadingCoeffs
  // keeps track of everything by that we divide in the course of the
  // Groebner basis computation
  storeLeadingCoeffs:=
  proc(f, o)
    local l, invl;
  begin
    // it may happen that the leading coefficient is zero
    // and that this is detected during inversion
    repeat
      invl:= FAIL;
      l:= lcoeff(f, o);
      if traperror((invl:= 1/l)) <> 0
        or traperror((f:= multcoeffs(f, invl))) <> 0 then
        f:= f - lmonomial(f, o);
        invl:= FAIL
      end_if;
    until invl <> FAIL or iszero(f) end_repeat;
    
    if invl <> FAIL and store then
      if testtype(expr(l), Type::Constant) <> TRUE then
        lcoefflist:= append(lcoefflist, l)
      end_if;
    end_if;
    f
  end_proc;


  
  sys:= syss;
  unk:= unkk;
 
  // do not store leading coeffs in sloppy-mode
  store:= not options[IgnoreSpecialCases] and not options[IgnoreAnalyticConstraints];
  assert(type(store) = DOM_BOOL);
  
  userinfo(3, "Entering solver for algebraic systems");
 
  sys:= prog::sort(sys, X -> if type(X) = "_plus" then nops(X) else 1 end_if);
  
  // very simple substitutions first
  for i from 1 to nops(sys) do 
    if type((g:= sys[i])) = DOM_IDENT then
      if traperror((sys:= subs(sys, g=0, EvalChanges))) <> 0 then
        return({})
      end_if;  
      sys[i]:= g
    elif type(g) = "_plus" and nops(g) = 2 then
      sys:= map(sys, divide, g, DegInvLexOrder, Rem);
      sys[i]:= g
    end_if  
  end_for;
  
  sys:= select(sys, _not@iszero);
  
  if nops(sys) = 0 then
    return(solvelib::cartesianProduct(getprop(unk[i]) $i=1..nops(unk)))
  end_if;

  if {op(map(sys, type))} intersect {DOM_INT, DOM_RAT} <> {} then
    return({})
  end_if;  
  
   // factor first
  for i from 1 to nops(sys) do 
    inds:= indets(sys[i]);
    if inds intersect {op(unk)} = {} then
      // the equation is constant: either it is zero, or the system is unsolvable
      g:= sys[i];
      delete sys[i];
      if options[IgnoreAnalyticConstraints] then
        return({})
      elif options[IgnoreSpecialCases] then
        if is(g=0, Goal = TRUE) then
          return(solve_algebraic_recursive(sys, unk))
        else
          return({})
        end_if
      else
        return(piecewise([g=0, solve_algebraic_recursive(sys, unk)],
                         [g<>0, {}]
                        )
              )
      end_if;
    elif nops(inds) <= 2 then
      g:= maprat(sys[i], Factor)
    else 
      g:= [1, sys[i], 1];
      for j from 1 to nops(unk) do 
        if iszero(subs(g[2], unk[j] = 0, EvalChanges)) then
          g:= g.[unk[j], 1];
          g[2]:= divide(g[2], unk[j], Quo); // really an exact division
          // divide off unk[j] as often as possible
          while((f:= divide(g[2], unk[j], Exact))) <> FAIL do 
            g[2]:= f
          end_while;  
        end_if;
      end_for;
      // alternative:
      // g:= maprat(sys[i], polylib::sqrfree)
    end_if;  
    if nops(g) = 1 then
      return({})
    elif nops(g) > 3 then // we may split the system 
      // do a special case for option PrincipalValue 
      if options[PrincipalValue] then
        for j from 2 to nops(g) step 2 do 
          gb:= solve_algebraic_recursive(subsop(sys, i= op(g, j)), unk);
          f:= solvelib::getElement(gb);
          if f <> FAIL then
            return({f})
          end_if  
        end_for;
        return({})
      else   
        gb:= _union(solve_algebraic_recursive(subsop(sys, i= op(g, 2*j)), unk) $j=1..nops(g) div 2);
        if type(gb) = DOM_SET then 
          gb:= {op(sort([op(gb)]))} 
        end_if;
        return(gb)
      end_if
    else // we may at least omit the exponent > 2
      sys[i]:= op(g, 2)
    end_if  
  end_for;
  
  if map({op(sys)}, testtype, Type::PolyExpr(unk, Type::Rational)) = {TRUE}
    then
    dm:=Expr;
    monic:= groebner::primpart
  else
    dm:=Dom::ExpressionField(normal, iszero@normal);
    monic:= storeLeadingCoeffs;
  end_if;

  sys:= map(sys, poly, unk, dm);

  
  
  /* first compute a basis wrt DegInvLexOrder */
  gb:=groebner::gbasis(sys, DegInvLexOrder, hold(Monic) = monic);
  /* then transform it in a LexOrder basis (the Grobner walk) */
  g:=groebner::gbasis(gb, LexOrder, hold(Monic)= monic );
  if nops(g) = 1 and iszero(op(g, 1)) then
    // solving {0} gives C_^n
    return(solvelib::cartesianProduct(getprop(unk[i]) $i=1..nops(unk)))
  end_if;
  g:=groebner::factor(g, LexOrder);


  solveIrreducibleFactor:=
  proc(g, unkOrig, lcflist)
    local gb, unk, sol;
  begin
    unk:= unkOrig;
    lcoefflist:= lcflist; // throw away changes made by Groebner base computations for other irreducible factors
    
    if nops(g) = 1 and degree(g[1])=0 then
      if iszero(g[1]) then
        userinfo(20, "Zero equation: everything is a solution");
        g:= solvelib::cartesianPower(C_, nops(unk))
      else
        g:= {} /* no solution */
      end_if;
      indepSets:= {};
      
    else
      
      // it may be that the order of unknowns has to be exchanged
      indepSets:= groebner::stronglyIndependentSets(g);
      userinfo(10, "Independent sets are :".expr2text(indepSets[3]));
      dimen:= indepSets[1];
      indepSets:= indepSets[2];
      // the number of indep. var. should equal the dimension of the variety
      assert(dimen = nops(indepSets));
      // now indepSets is a set x1, x2, ..., xn of variables,
      // such that the solutions to the system can be expressed as
      // [x1 = ..., x2 = ..., ..., xn = ...]
      
      unk:= split(unk, v -> not contains(indepSets, v));
      assert(unk[3] = []);

      if nops(unk[2])= 0 then
        userinfo(10, "Zero-dimensional system")
      else
        dm:=Dom::ExpressionField(normal, iszero@normal);
        monic:= storeLeadingCoeffs;
        g:= map(g, poly, unk[1], dm);
        // the grobner basis has to be re-computed, and the order of variables
        // must not be changed
        g:=groebner::gbasis(g, LexOrder, hold(Monic)= monic );
      end_if;
      
  
      userinfo(2,"Groebner basis is",map(g, expr));
      userinfo(2,"Groebner basis is valid if the following leading coefficients ".
    "are all nonzero:".expr2text(lcoefflist));
  
    
  
      g:=groebner::triangular_set(g);
      unk:= unk[1];

      g:=_union(op(map(g, solvelib::allvals, unk, unkOrig, options)));
    end_if;

    assert(testtype(g, Type::Set));
    
    if nops(lcoefflist) = 0 then
      // toDo: add positions to free2Bound
      g:= solvelib::free2Bound(g, [op(indepSets)]);
      unk:= unk.[op(indepSets)];
      g:= solvelib::selectIndices
      (g, [contains(unk, unkk[i]) $i=1..nops(unkk)] );
      if g<>FAIL then
        return(g)
      end_if;
    else
      // we only store leading coefficients if the variable "store"
      // above is TRUE
      assert(not options[IgnoreSpecialCases] and not options[IgnoreAnalyticConstraints]);
      lcoefflist:= map(lcoefflist, expr);
      cond:= _and(op(map(lcoefflist, _unequal, 0)));
      // search for degree 1 leading coefficient:
      // if it exists, we also solve the special case
      linear:= FAIL;
      for lc in lcoefflist do
        inds:= indets(lc);
        for i in inds do
          if testtype(lc, Type::PolyExpr([i])) and
            degree(lc, [i]) = 1 then
            linear:= [lc, i];
            break
          end_if
        end_for;
        if linear <> FAIL then break; end_if
      end_for;
    
    
      if linear <> FAIL then
        gb:= poly(linear[1], [linear[2]]);
        sol:= solvelib::free2Bound
             (
              piecewise([cond, g],
                [linear[1] = 0,
                 solve(subs(syss,
                            linear[2] = -coeff(gb, 0) / coeff(gb, 1)),
                       unk, options)], 
                [not cond and linear[1] <> 0, {}]       
                       ),
             [op(indepSets)]);
        unk:= unk.[op(indepSets)];
        sol:= solvelib::selectIndices
        (sol, [contains(unk, unkk[i]) $i=1..nops(unkk)] );
        if sol <> FAIL then
          return(sol)
        end_if
      end_if;
    
    // if nothing helps, accept also higher degree polynomials

      for lc in lcoefflist do
        inds:= indets(lc);
        for i in inds do
          if testtype(lc, Type::PolyExpr([i])) then
            linear:= [lc, i];
            break
          end_if
        end_for;
        if linear <> FAIL then break; end_if
      end_for;

      // attach the condition ,,leading coeff = 0'' as
      // additional equation to the polynomial system, and start over
      if linear <> FAIL then
        if contains(unk, i) > 0 then
          sol:= piecewise([cond, g], 
                          [not cond, solvelib::solve_algebraic(syss.[linear[1]], unk, options)]
                          )
        else 
          sol:= solvelib::free2Bound
          (
          piecewise([cond, g],
                    [not cond, solvelib::bound2Free
                     (solvelib::solve_algebraic
                      (syss.[linear[1]], unk.[i], options),
                      nops(unk)+1, i)]),
           [op(indepSets)])
        end_if;
        unk:= unk.[op(indepSets)];
        sol:= solvelib::selectIndices
        (sol, [contains(unk, unkk[i]) $i=1..nops(unkk)] );
        if sol <> FAIL then
          return(sol)
        end_if
      end_if;
      // only non-polynomial leading coefficients
      sol:= solvelib::free2Bound(piecewise([cond, g]), [op(indepSets)]);
      unk:= unk.[op(indepSets)];
      sol:= solvelib::selectIndices
      (sol, [contains(unk, unkk[i]) $i=1..nops(unkk)]);
      if sol <> FAIL then
        return(sol)
      end_if
    end_if;
    hold(solve)(g, unk)
  end_proc;

  if nops(g) = 0 then
    solveIrreducibleFactor([1], unk, lcoefflist)
  else  
    _union(op(map(g, solveIrreducibleFactor, unk, lcoefflist)))
  end_if
end_proc:

solve_algebraic_recursive(args())

end_proc:


/*--
solvelib::allvals(g, unk, unk2, options)

g - a list of polynomials, in triangular form
unk - set of unknowns
unk2 - set of variables that should not be replaced
options - table of options, as returned by solvelib::getOptions()

returns an expression of the form unk in set


--*/

solvelib::allvals :=
proc(g: Type::ListOf(DOM_POLY),
     unk: Type::ListOf(DOM_IDENT),
     unk2: Type::ListOf(DOM_IDENT), 
     options: DOM_TABLE)
  local sol,
  i, j, r,
  freeInd: DOM_SET,
  toSubs,
  backSubstitute: DOM_PROC;
  
begin

  // local methods

  // backSubstitute
  backSubstitute:=
  proc(solution)
    local
    backSubs: DOM_PROC,
    subsvec: DOM_PROC;
  begin

    // local method subsvec
    // replace any occurence of elements of vars
    // variables: variables that are bound variables, and must not appear in the condition
    subsvec:=
    proc(v: matrix, variables: DOM_SET)
      local cond;
    begin
      v:= [op(v)];
      cond:= _and(op(showprop(unk)));
      while has(v, {op(unk)}) do
        // no eq. should be of the form x=f(x)
        assert(zip(v, unk, has) = [FALSE $nops(v)]);
        // solution is valid if each v[i] is consistent with the
        // properties of unk[i]
        if not options[IgnoreProperties] then
           cond:= subs(cond, unk[i] = v[i] $i=1..nops(unk),EvalChanges)
        end_if;
        v:= subs(v, unk[i] = v[i] $i=1..nops(unk),EvalChanges)
      end_while;
      if cond = TRUE or has(cond, variables) then
        // conditions containing the variables may be omitted, as they have been taken into account when constructing the solution
        {matrix(v)}
      else
        piecewise([cond, {matrix(v)}], [not cond, {}])
      end_if
    end_proc;
    
    // local method backSubs  
    backSubs:=
    proc(S)
      local i: DOM_INT, v, exprS, variables;
    begin
      case type(S)
        of piecewise do
          return(_union
                 (
                  solve(piecewise::condition(S, i), unk, VectorFormat)
                  intersect
                  backSubs(piecewise::expression(S, i))
                  $i=1..nops(S)
                  ))
        of "_union" do
          return(map(S, backSubs))
        of DOM_SET do
          return(_union(op(map(S, subsvec, {}))))
        of solvelib::VectorImageSet do
          variables:= {op(S::dom::variables(S))};
          S:= S::dom::avoidAliasProblem(S, {op(unk2)});
          exprS:= subsvec(expr(S), variables);
          return(piecewise::extmap
                 (exprS,
                  loes -> if loes={} then
                            {}
                          else
                            _union(extsubsop(S, 1 = v) $v in loes)
                          end_if
                  ))
      end_case;
      S
    end_proc;
    
    backSubs(solution)
  end_proc; // backSubstitute

  /////////////////////////////////////////
  //  main program of solvelib::allvals  //
  /////////////////////////////////////////
  
  // if the ideal is <1>, there is no solution
  if nops(g) = 1 and degree(g[1]) = 0 then
    return({})
  end_if;

  freeInd:= indets(map(g, expr));
  
  // strange but true: the only zero-dimensional vector is ...
  sol:= {matrix(0, 1, [])};
  
  for i from nops(unk) downto 1 do

    // add the constraints imposed by the last equation

    // if we have already solved for the last variable appearing in that
    // equation,  go on
    repeat
      r:= g[nops(g)];
      delete g[nops(g)]
    until not has (op(r,1), {op(unk, 1..i-1)}) end_repeat;

    // we know that the system is zero-dimensional:
    // this is why we have extracted the independent sets before
    // thus, unk[i] must really show up
    assert(has(op(r, 1), unk[i]));

    j:= solve(poly(op(r,1),[unk[i]]), unk[i], options);
    assert(type(j) <> "solve");
    userinfo(5, "Solving polynomial ".expr2text(op(r,1))." gives ".
             expr2text(j));
    
    // we have to the component j in front of each solution

    assert(testtype(j, Type::Set) = TRUE);
    sol:= solvelib::cartesianProduct(j, sol);
    sol:= solvelib::avoidAliasProblem(sol, {op(unk2)} union freeInd);
    assert(testtype(sol, Type::Set) = TRUE);
    
    userinfo(5, "Solutions so far are ".expr2text(sol));


  end_for; // i from nops(unk) downto 1

 
  
 

  r:= {op(unk2)} union freeInd; // forbidden idents

  toSubs:= indets(sol) minus r minus
    indets(map(g, op, 2))
    minus Type::ConstantIdents;

  r:= {op(solvelib::getMultipleIdent(C_, nops(toSubs), r))};
  
  [toSubs, r]:= map([toSubs, r], _minus, toSubs intersect r);
    
  sol:= subs(sol, zip([op(toSubs)], [op(r)], _equal),EvalChanges);
  
  if options[BackSubstitution] then
    backSubstitute(sol)
  else  
    sol
  end_if
end_proc:

/* end of file */

