/* allvalues(s) returns all complex solutions of a polynomial
  system, where s is the symbolic solution.

Example:
>> s:=solve({x^4+x+1,y^4+x+1},{x,y}):
>> DIGITS:=3: allvalues(s);
*/ 

solvelib::allvalues_warning:= proc()
local warning_issued;
option escape;
begin
  warning_issued:= FALSE;
  proc(string) begin
    if not warning_issued then
       warning(string);
       warning_issued:= TRUE;
       return();
    end_if:
  end_proc:
end_proc():

solvelib::allvalues := 
proc(s)
local eq,x,sol,v;
begin
  userinfo(3, "solvelib::allvalues called with ".expr2text(s));
  case type(s)
    of DOM_SET do
       return(_union(map(s,op@solvelib::allvalues)))
    of DOM_LIST do
      if s=[] then
        return({[]})
      end_if;
      eq:=s[nops(s)];
      x:=op(eq,1);
      eq:=op(eq,2);
      delete s[nops(s)];
      // the current output format of solve guarantees that there is no RootOf here
      assert(not hastype(eq, RootOf));
      eq:=[float(eq)];
      sol:={};
      for v in eq do
         sol:=sol union map(solvelib::allvalues(subs(s,x=v)),append,x=v)
      end_for;
      return(sol)
   of "solve" do
      if nops(s)<3 then
        solvelib::allvalues_warning("solution(s) may be lost");
        s:= numeric::fsolve(op(s));
        if s<>[] and s<>FAIL then
          return({s})
        else
          return({})
        end_if;
      end_if;
    otherwise
      s:= float(s);
  end_case;
  return(float(s));
end_proc:
