domain solvelib::cartesianPower
  inherits Dom::BaseDomain;
  category Cat::Set;


    new:=
    proc(S: Type::Set, n: Type::PosInt)
    begin
      if testargs() then
        if type(S) = solvelib::cartesianPower then
          error("Illegal argument")
        end_if
      end_if;
      if domtype(S) = DOM_SET then
        {op(map(combinat::cartesianProduct(S $ n), matrix))}
      elif domtype(S) = piecewise then
        piecewise::extmap(S, solvelib::cartesianPower, n)
      else
        new(dom, S, n)
      end_if
    end_proc;


    convert:=
    proc(a)
    begin
      if domtype(a) = dom then
        a
      else
        FAIL
      end_if
    end_proc;


    base:= S -> extop(S, 1);

    dimension:= S -> extop(S, 2);
    
    subs := S -> extsubsop(S, 1=subs(extop(S, 1), args(2..args(0))));
    
    evaluate := S -> dom::new(eval(extop(S, 1)), extop(S, 2));

    /* union, intersect, minus */


    homog_union:=
    proc()
      local d, basunion;
    begin  
      d:= map({args()}, dom::dimension);
      if nops(d) > 1 then
        FAIL
      else
        basunion:= _union(map(args(), dom::base));
        dom::new(basunion, op(d, 1))
      end_if
    end_proc;
    
    homog_intersect:=
    proc()
      local d;
    begin
      d:= map({args()}, dom::dimension);
      if nops(d) <> 1 then
        return({})
      else
        d:= op(d)
      end_if;
      dom::new(_intersect(map(args(), dom::base)), d)
    end_proc;

    bin_minus:=
    proc(S: dom, T: dom)
      local dimS, dimT;
    begin
      dimS:= dom::dimension(S);
      dimT:= dom::dimension(T);
      if dimS <> dimT then
        // vectors of different dimension are different
        S
      elif dom::base(S) subset dom::base(T) = TRUE then
        {}
      elif dimS = 1 then
        dom::new(solvelib::solve_minus(dom::base(S), dom::base(T)), 1)
      else
        FAIL
      end_if;
    end_proc;
    
    inhomog_union:=
    table(
          DOM_SET =
          proc(CP: solvelib::cartesianPower, S: DOM_SET )
            local Snew;
          begin
            if op(CP, 1) = C_ then
              // do not check whether S has the correct dimension
              return(CP)
            end_if;  
            Snew:= CP intersect S;
            if type(Snew) = DOM_SET then
              S:= S minus Snew;
              if S={} then
                return(CP)
              else
                return(hold(_union)(CP, S))
              end_if
            end_if;
            FAIL
          end_proc,
          
          DOM_EXPR =
          proc(CP: solvelib::cartesianPower, S)
          begin
            if op(CP, 1) = C_ then 
              // do not check whether S has the correct dimension
              return(CP)
            end_if;
            FAIL 
          end_proc
          

          // solvelib::VectorImageSet: handled there
          );

    inhomog_intersect:=
    table(
          DOM_SET =
          proc(CP: solvelib::cartesianPower, S: DOM_SET )
            local B;
          begin
            if CP::dom::dimension(CP) <> solvelib::dimension(S) then
              return({})
            end_if;
            B:= CP::dom::base(CP);
            _union(op(map(S,
                          proc(s)
                            local i, cond;
                          begin
                            cond:= _and(s[i] in B $i=1..nops(s));
                            piecewise([cond, {s}],
                                      [not cond, {}])
                          end_proc
                     )))
          end_proc,

          piecewise =
          proc(CP: solvelib::cartesianPower, pw: piecewise)
          begin
            piecewise::extmap(pw, solvelib::solve_intersect, CP)
          end_proc,
          
          solvelib::VectorImageSet =
          proc(CP: solvelib::cartesianPower, VS: solvelib::VectorImageSet)
            local S, l, i;
          begin
            if op(CP, 1) = C_ then
              return(VS)
            end_if;
            if op(CP, 2) = 1 then
              if solvelib::dimension(VS) <> 1 then
                return({})
              else
                S:= solvelib::vectorSetToNumberSet(VS);
                if S <> FAIL then
                  return(solvelib::cartesianPower(S intersect op(CP, 1), 1))
                end_if
              end_if
            end_if;
            l:= solvelib::splitVectorSet(VS, op(CP, 2));
            if l = FAIL then
              FAIL
            else
              // we use that the intersection of CP1 x CP1 x ... and
              // l[1] x l[2] x ... can be computed factorwise
              for i from 1 to nops(l) do
                l[i]:= l[i] intersect op(CP, 1);
                if type(l[i]) = "_intersect" then
                  return(FAIL)
                end_if;
              end_for;
              solvelib::cartesianProduct(op(l))  
            end_if
          end_proc,

          DOM_EXPR =
          proc(CP: solvelib::cartesianPower, a: DOM_EXPR )
          begin
            if CP::dom::base(CP) = C_ then
              a
            else
              FAIL
            end_if
          end_proc
          );
    

    inhomogleft_minus:=
    table(
          DOM_SET =
          proc(CP: solvelib::cartesianPower, S: DOM_SET)
            local s;
          begin
            if S = {} then
              CP
            elif op(CP, 2) = 1 then
              s:= solvelib::vectorSetToNumberSet(S);
              if s = FAIL then
                FAIL
              else
                solvelib::cartesianPower
               (solvelib::solve_minus(op(CP, 1), s),
                1)
              end_if
            else
              FAIL
            end_if
          end_proc
          );


    inhomogright_minus:=
    table(
          DOM_SET =
          proc(S: DOM_SET, CP: solvelib::cartesianPower)
            local simpIn, s;
          begin
           simpIn:= CP::dom::simpexIn;
            _union(piecewise([simpIn(s, CP), {}],
                             [Otherwise, {s}])
                   $s in S
                   )   
          end_proc
          );
    

    simpexIn:=
    proc(a, CP)
      local bas, i;
    begin
      bas:= op(CP, 1);
      _and(a[i] in bas $i=1..op(CP, 2)) 
    end_proc;
    
    getElement:=
    proc(CP: dom)
      local l: DOM_LIST,
      i: DOM_INT;
    begin
      l:= [0 $ dom::dimension(CP)];
      for i from 1 to nops(l) do
        l[i]:= solvelib::getElement(op(CP, 1), args(2..args(0)));
        if l[i] = FAIL then
          return(FAIL)
        end_if
      end_for;
      matrix(l)
    end_proc;
    
    float:= CP -> dom::new(float(extop(CP, 1)), extop(CP, 2));

    expr:= CP -> hold(_power)(extop(CP, 1), extop(CP, 2));

    expr2text:= CP -> hold(solvelib::cartesianPower)(extop(CP, 1), extop(CP, 2));

    print:=
    proc(CP)
    begin
      hold(_power)(extop(CP, 1), extop(CP, 2))
    end_proc;

    
end_domain:




