

solvelib::convertToAssignments:=
proc(solution, vars: DOM_LIST)
  local conv: DOM_PROC, result, newIdents: DOM_LIST, dependsOn: DOM_SET;
begin

  conv:=
  proc(set)
    local sol;
  begin
    case type(set)
      of DOM_SET do
        return(map(set, mat -> zip(vars, [op(mat)], _equal)))
      of piecewise do
        result:= piecewise::extmap(set, conv);
        if map({op(piecewise::expressions(result))}, type) intersect
          {"_in", "solve"} <> {} then
          break
        end_if;
        return(result)
      of "_union" do
        result:= map([op(set)], conv);
        if map({op(result)}, type) intersect {"_in", "solve"} <> {} then
          break
        end_if;
        return(_union(op(result)))
      of solvelib::VectorImageSet do
        if {op(set::dom::sets(set))} = {C_} then 
          sol:=  [op(expr(set))];
          // we have to take care that [x(t) = z, y(t) = z]
          // becomes [x(t) = z(t), y(t) = z(t)] if z is a newly
          // generated variable
          // first, we determine the set of all independent variables
          dependsOn:= {op(map(select(vars, testtype, "function"), op))};
          if nops(dependsOn) > 0 then
            newIdents:= set::dom::variables(set);
            sol:= subs(sol, zip(newIdents,
                                map(newIdents, x-> x(op(dependsOn))),
                                _equal))
          end_if;
          sol:= zip(vars, sol, _equal);
          return({sol})
        else
          return(matrix(vars) in set)
        end_if
      of solvelib::cartesianPower do
        if op(set, 1) = C_ then
          newIdents:= solvelib::getMultipleIdent(C_, nops(vars), {op(vars)});
          return({zip(vars, newIdents, _equal)})
        else
          return(matrix(vars) in set)
        end_if
    end_case;

    return(matrix(vars) in set)
  end_proc;

  
  if type(solution) = "solve" then
    return(hold(solve)(op(select([op(solution)],
                                 X -> op(X, 1) <> VectorFormat))))
  end_if;

  conv(solution)

end_proc: