
solvelib::dimension:=
proc(S)
  local a;
begin
  if S::dom::dimension <> FAIL then
    return(S::dom::dimension(S))
  end_if;
  
  case type(S)
    of DOM_SET do
      if not contains({matrix, DOM_LIST}, type(op(S, 1))) then
        return(1)
      else
        return(nops(op(S, 1)))
      end_if
    of piecewise do
      a:= piecewise::expressions(S);
      a:= map({op(a)}, solvelib::dimension) minus {-1};
      case nops(a)
        of 0 do
          return(-1)
        of 1 do
          return(op(a, 1))
      end_case;
      error("Inconsistent dimensions in piecewise")
    of Dom::ImageSet do
    of solvelib::VectorImageSet do  
      a:= expr(S);
      if not contains({DOM_LIST, matrix}, type(a)) then
        return(1)
      else
        return(nops(a))
      end_if;
    of "Union" do  
    of "_union" do
    of "_intersect" do
    of "_minus" do
      return(solvelib::dimension(op(S, 1)))
    of "solve" do
      if contains({DOM_SET, DOM_LIST}, type(op(S, 2))) then
        return(nops(op(S, 2)))
      else
        return(1)
      end_if
    of Dom::Interval do
    of solvelib::BasicSet do
    of RootOf do
      return(1)
    of "cartesianProduct" do
      return(_plus(op(map([op(S)], solvelib::dimension))))
    otherwise
      error("Unknown set type ".expr2text(type(S)))
  end_case;
        

end_proc:

solvelib::dimension({}):= -1:
solvelib::dimension({[]}):= 0: