/*++ 

solvelib::discreteSolve(arguments)

arguments - the same as for solve 

modifies the set of solutions returned by solve in a way that ode::solve can handle it 

returns a set or FAIL 

++*/


solvelib::discreteSolve:=
proc()
  local s, e, res,checkResult,chooseSet, lres, i:DOM_INT, 
        possibleOptions, opts;
begin
  //=========================================================
  // SUBPROCEDURE
  // local check function of solve's result
  checkResult:=
  proc(s)
    local res;
  begin
    case type(s)
      of piecewise do
        res:=chooseSet(s);
        if res<>{} then
          return(res)
        else
          return(FAIL)
        end_if;
      of Dom::Multiset do
      of RootOf do 
      of "solve" do 
      of DOM_SET do
        return(s)
      of "_minus" do
        return(checkResult(op(s, 1)))
      of Dom::ImageSet do
      of solvelib::VectorImageSet do  
        res:=solvelib::getElement(s);
        if res = FAIL then
          return(FAIL)
        else 
          return({res})
        end_if;
      // this case never occurs in any test example. Mar 17, 2010
      /*
      of "_union" do   
        lres:=map([op(s)],solvelib::getElement);
        res:=_union(op(map(lres,e->if e=FAIL then null()
                                   elif type(e)<>DOM_SET
                                     then {e} else e
                                   end_if)));
        if res<>{} then return(res) else return(FAIL) end_if; break;
      */
      otherwise
        return(FAIL);
    end_case;
  end_proc;

  //=========================================================
  // SUBPROCEDURE
  // heuristic to extract from piecewise 
  chooseSet:=  
    proc(pw: piecewise)
      local i,s,cmp,r;
    begin
      s:=select([piecewise::expression(pw,i) $ i=1..extnops(pw)],
          e->if domtype(e)=DOM_SET and e<>{} or domtype(e)=Dom::ImageSet
             or type(e)="solve" or hastype(e, RootOf) then TRUE else FALSE
                end_if);
      if nops(s)>1 then
        cmp:=(a,b)->bool(nops(a)<nops(b)) or has({op(a)}, {C_,R_,Q_,Z_});
        s:=sort(s,not cmp);
      end_if;
      if nops(s)=0 then
        r:={}
      elif domtype(s[1])=Dom::ImageSet then
        r:={solvelib::getElement(s[1])}
      elif type(s[1])="_minus" then
        r:=op(s[1], 1)
      else
        r:=s[1]
      end_if;
      if has([r],FAIL) then
        FAIL
      else
        r
      end_if;
    end_proc;

  //=========================================================
  // MAIN PROCEDURE of 'solvelib::discreteSolve'
  //=========================================================
  userinfo(5, "...entering discreteSolve with arguments",args());

  /* 
   Note by Kai: Note that from now on (May, 13th, 2008)
                there are 'solveOptions' handed over 
                by ODE calling 'discreteSolve' among 
                'args()'.        
      
   TODO: Here we have to change the call of 'solve' in the 
         future. It maybe better that the user himself 
         gives 'IgnoreSpecialCases' to 'solve' instead that 
         'ode' does this implicitly itself. The question is     
         whether 'ode' will be able to deal the results 
         provided by 'solve' if 'IgnoreSpecialCases' is 
         no longer used by default internally. 
  */
  
  possibleOptions:= {Multiple, PrincipalValue, MaxDegree, BackSubstitution,
                     VectorFormat, Domain, IgnoreProperties, 
                     IgnoreSpecialCases, DontRewriteBySystem, MaxRecLevel, 
                     NoWarning, Real, IgnoreAnalyticConstraints}:
                      
  if args(0) >= 2 and indets(args(2)) intersect possibleOptions <> {} then
    opts:= args(2..args(0));
  else
    opts:= args(3..args(0));
  end_if;                    
  
  s:=solve(args(), IgnoreProperties, IgnoreSpecialCases);
  userinfo(5, "solve returns ",s);
  case type(s)
    of RootOf do
      res:=s;
      break
    of piecewise do
      res:=checkResult(piecewise::disregardPoints(s)); 
      break;
    of Dom::Multiset do;
    of "solve" do ;
    of DOM_SET do
      res:=s; 
      break;
    of "_minus" do
      if domtype(op(s)[1])=RootOf then
        res:={op(s)[1]}
      /*
      // this case never occurs in any test example. Mar 17, 2010
      elif type(op(s)[1])="_union" then
        res:=op(op(s)[1], 1) minus op(s)[2] union op(op(s)[1], 2);
        if type(res)<>"solve" then
          res:=checkResult(op(s)[1])
        end_if:
      */
      else
        res:=checkResult(op(s)[1])
      end_if; 
      break;
    of "_in" do
      res:=checkResult(op(s,2));
      if type(res)=DOM_SET
      then
        res:={[op(s,[1, i])=op(e, i) $i=1..nops(op(s, 1))] $ e in res}
      else
        res:=FAIL
      end_if;
      break;
    of "_union" do
      // first treat piecewise
      // within a _union, no piecewise can occur (would be prevented by piecewise::_union)
      lres:= [op(s)];
      // check any single result separately
      lres:=map(lres,checkResult);
      // sorry, but only extract elements of type DOM_SET and RootOf
      res:=_union(op(map(lres,e->case domtype(e)
                                   of RootOf do {e}; break;
                                   of DOM_SET do e; break;
                                   otherwise null()
                                 end_case)));
      if res={} then
        res:=FAIL
      end_if; 
      break;
    /*
    // we have no example whre any object of type "Union" occurs. Stefan, Mar 17, 2010
    of "Union" do
      // first treat piecewise
      if type(op(s)[1])=piecewise then
        lres:=[piecewise::disregardPoints(op(s)[1])]
      else
        lres:=[op(s)[1]]
      end_if;
      // check any single result separately
      lres:=map(lres,checkResult);
      // sorry, but only extract elements of type DOM_SET and RootOf
      res:=_union(op(map(lres,
                         e->
                         case domtype(e)
                           of RootOf do
                             {e};
                             break;
                           of DOM_SET do
                             e;
                             break;
                           otherwise
                             null()
                         end_case))
                  );
      if res={} then
        res:=FAIL
      end_if;
      break;
    */
    of Dom::ImageSet do
      res:=solvelib::getElement(s);
      if has([res],FAIL) then
        res:=FAIL
      else
        res:={res}
      end_if;
      break;
    otherwise
      res:=FAIL;
  end_case;
  
  res
end_proc:

      
// end of file
