
/* 

 solvelib::free2Bound(sol, vars)

 sol - set of vectors
 vars - list of identifiers

 take a solution sol from the system solver
 and make the elements of vars from parameters to variables  
 that is, given a set sol of n-dimensional vectors
 (a_1(x_1, .., xk), ..., an(x_1, ..., x_k)) and [x_1, .., x_k],
 free2Bound returns a set S of n+k - dimensional vectors
 such that
 (y_1, .., y_{n+k}) \in S iff
 (y_1(y_{n+1}, .., y_{n+k}), ... , y_n(y_{n+1}, ..., y_{n+k})) \in sol
 for some values of x_1, ..., x_k
*/

solvelib::free2Bound:=
proc(sol: Type::Set, vars: DOM_LIST)
  local i: DOM_INT, doBranch, l;
  save MAXEFFORT;
begin
  
  // quick exit
  if vars=[] then
    return(sol)
  end_if;

  
  // doBranch(cond, object):
  /* extract the solutions from [cond, object], making the parameters in vars
     to variables

     object: an n-dimensional set (possibly depending on vars)
     cond: a condition
  */
  
  doBranch:=
  proc(cond, object: Type::Set)
    local S,
    substituteElements: DOM_PROC,
    appendVectors: DOM_PROC,
    substituteEl: DOM_PROC;
  begin

    // compute the set {linalg::stackMatrix(x, vec); x \in M}
    appendVectors:=
    proc(M: Type::Set, vec)
      local newid,i ;
    begin
      case type(M)
        of DOM_SET do
          return(map(M, linalg::stackMatrix, vec))
        of solvelib::VectorImageSet do
          return(map(M, linalg::stackMatrix, vec))
        of solvelib::cartesianPower do
          newid:= [genident() $i=1..op(M, 2)];
          return(solvelib::VectorImageSet
                 (linalg::stackMatrix(matrix(newid), vec), newid,
                                          [op(M, 1) $op(M, 2)]))
        of "_union" do
        of "_intersect" do
        of "_minus" do
          return(map(M, appendVectors, vec))
      end_case;
      // default
      solvelib::cartesianProduct(M, {vec})
    end_proc;
    
    
    substituteElements:=
    proc(S)
      local parametrizedSet, i;
      save MAXEFFORT;
    begin
      case domtype(S)
        of DOM_SET do
          if nops(S) > 1 then
            MAXEFFORT:= MAXEFFORT/nops(S)
          end_if;
          return(_union(op(map(S, substituteEl))))
        of "_union" do
          MAXEFFORT:= MAXEFFORT/nops(S);
          return(map(S, substituteElements))
      end_case;
      // default: create a set of vectors of correct dimension,
      // containing the elements of vars as free variables
      parametrizedSet:= appendVectors(object, vars);
      solvelib::Union(parametrizedSet, vars, S)
    end_proc;

    substituteEl:=
    proc(v)
      local result;
    begin
      if traperror((
      result:= appendVectors((object | zip(vars, [op(v)], _equal)), v)
               )) <> 0 
      then
        {}   
      else
        result
      end_if
    end_proc;
          
    // main program of
    // doBranch
    
    // simple case: the empty set remains empty, whatever cond is
    if object = {} then 
      return({})
    end_if;  
    S:= solve(cond, vars, VectorFormat);
    // for each element  s \in S, we have to substitute the variables in
    // vars by the components of that element, everywhere in object
    // and then append the components of s to each element of object
    substituteElements(S)        
  end_proc; // doBranch

  
  // m a i n   p r o g r am  o f  f r e e 2 B o u n d

  case type(sol)
    of piecewise do
      if nops(sol) > 4 then
        return(doBranch(0=0, sol, vars))
      end_if;  
      MAXEFFORT:= MAXEFFORT/nops(sol); 
      sol:= piecewise::replaceOtherwise(sol);
      l:= [doBranch(piecewise::condition(sol, i),
                    piecewise::expression(sol, i), vars)
              $i=1..nops(sol)];
      if _mult(op(map(l, piecewise::numberOfBranches))) > 10 then
        // return(hold(_union)(op(l)))
        return(doBranch(0=0, sol, vars))
      else
        return(_union(op(l)))
      end_if  
    of "solve" do
      // return an unevaluated solve-call, but with additional
      // variables from vars
      case type(op(sol, 2)) 
        of DOM_LIST do
          op(sol, 2).vars;
          break
        of DOM_IDENT do
          [op(sol, 2)].vars;
          break
        otherwise
          error("Unknown type of second argument to solve-call")
      end_case;
      return(subsop(sol, 2= %))      
    otherwise
      // default
      return(doBranch(0=0, sol, vars))
  end_case;

  // NOT REACHED
  assert(FALSE)
  
end_proc:

