//   

/*

solvelib::getElement(S)
returns *one* element of S, which is the same in every call
solvelib::getElement(S, Random)
returns one randomly chosen element of S

returns FAIL in either case if no element could be found


*/


solvelib::getElement:=
proc(S)
  local i:DOM_INT, l: DOM_LIST, bs, iv,
  result, rand: DOM_BOOL;

begin
  if args(0) = 0 then
    error("argument expected")
  end_if;
  
  if S::dom::getElement <> FAIL then
    return(S::dom::getElement(args()))
  end_if;

  case args(0)
    of 1 do
      rand:= FALSE;
      break
    of 2 do
      if args(2) <> Random then
        error("Illegal option")
      end_if;
      rand:= TRUE;
      break
    otherwise
      error("Too many arguments")
  end_case;
  
  case type(S)
    of DOM_SET do
      if nops(S)=0 then
        FAIL
      elif rand then
        op(S, 1 + (random() mod nops(S)))
      else
        op(S, 1)
      end_if;
      break
    of "_union" do
      if rand then
        l:= select([op(S)],
                   T-> type(T) = DOM_SET or T::dom::getElement <> FAIL or
                   type(T) = "Union" and (op(T, 3))::dom::getElement <> FAIL);
        if nops(l) = 0 then
          return(FAIL)
        end_if;
        i:= 1 + (random() mod nops(l));
        return(solvelib::getElement(l[i], Random))
      else
        i:=1;
        repeat
          result:=solvelib::getElement(op(S,i));
          i:=i+1
        until i>nops(S) or result<>FAIL end_repeat;
        return(result)
      end_if
    of "_minus" do
      // there is no general method to find an element of the first set that is not in the second set 
      // we just try one element, and give up afterwards
      result:= solvelib::getElement(op(S, 1), args(2..args(0)));
      if result = FAIL or not is(not result in op(S, 2), Goal = TRUE) then
        // special case for Z_, Q_, R_, C_
        if type(op(S, 1)) = solvelib::BasicSet then
           for result in [1, -1] do
             if is(not result in op(S, 2), Goal = TRUE) then
                return(result)
             end_if
           end_for;
        end_if;
        return(FAIL) 
      else
        return(result)
      end_if;
    of "_intersect" do
      // we can only handle one special case
      if nops(S) = 2 then
        l:= map([op(S)], type);
        if l = [solvelib::BasicSet, Dom::Interval] then
          bs:= op(S, 1);
          iv:= op(S, 2)
        elif l = [Dom::Interval, solvelib::BasicSet] then
          iv:= op(S, 1);
          bs:= op(S, 2);
        else
          return(FAIL)
        end_if;
        assert(bs = Z_ or bs = Q_);
        if iv::dom::left(iv) = -infinity then
          return(floor(iv::dom::right(iv) - 1))
        elif iv::dom::right(iv) = infinity or is(iv::dom::right(iv) - iv::dom::left(iv) > 2, Goal = TRUE) then
          return(ceil(iv::dom::left(iv) + 1))
        end_if;
        return(FAIL)
      end_if;
      return(FAIL)
    of "Union" do
      // there can be no general heuristic
      result:= solvelib::getElement(op(S, 3), args(2..args(0)));
      if result = FAIL then
        FAIL
      elif type(op(S, 2)) = DOM_LIST then
        assert(nops(op(S, 2)) = nops(result));
        if traperror((result:= op(S, 1) | zip(op(S, 2), [op(result)], _equal))) <> 0 then 
          return(FAIL)
        else   
          solvelib::getElement(result,
          args(2..args(0)))
        end_if  
      else
        if traperror((result:= op(S, 1) | op(S, 2) = result)) <> 0 then
          FAIL
        else  
          solvelib::getElement(result, args(2..args(0)))
        end_if
      end_if;
      break
    otherwise
      FAIL
  end_case
end_proc:



