//   
/*
    solvelib::getIdent(S, Forbidden)

    returns an identifier X suitable for ranging over S as a bound identifier
    in expressions like {f(X); X in S}

    X satisfies:
    - it has no value
    - it has no properties, or the property of being in S
    - it is not in the set Forbidden
    - it is no free identifier of S

    among all identifiers eligible according to this criteria,
    that one first appearing in the list of preferred identifiers is chosen;
    if no identifier in that list can be used, a new identifier with preferred
    prefix is created

*/


solvelib::getIdent:=
proc(S, Forbidden = {}: DOM_SET)
  local
  Sprop,
  identlist: DOM_LIST,
  i: DOM_INT,
  suitable: DOM_PROC,
  prefix: DOM_IDENT;

begin
  // local method
  suitable:=
  proc(X): DOM_BOOL
    local props;
  begin
    _lazy_and(type(X) = DOM_IDENT,
              protected(X) = None,
              eval(hold(val)(X)) = X,
              ((props:= property::showprops(X));
               props = [] or props = [X in Sprop]),
              not contains(Forbidden, X))
  end_proc;

  Sprop := S;

  case expr2text(type(S))
    of "\"_minus\"" do
    of "\"_intersect\"" do
      return(solvelib::getIdent(op(S, 1), Forbidden union
                                indets([op(S, 2..nops(S))])))
    of "Dom::Interval" do
      return(solvelib::getIdent(R_, indets(S) union Forbidden))
    of "solvelib::BasicSet" do
      break;
    otherwise
      Sprop := C_;
      if not contains(solvelib::preferredIdents, S) then
        Forbidden:= Forbidden union indets(S);
        S:= C_;
      end_if;
  end_case;

  // default: search the list of preferred identifiers
  identlist:= solvelib::preferredIdents[S];
  for i from 1 to nops(identlist) do
    if suitable(identlist[i]) then
      return(identlist[i])
    end_if
  end_for;

  // if this did not succeed, choose an identifier with preferred prefix:
  prefix:= solvelib::preferredPrefixes[S];
  i:= 1;
  while not suitable(prefix.i) do
    i:= i+1
  end_while;
  prefix.i
end_proc:

solvelib::preferredIdents:=
table(
      Z_ = [k, l, m, n],
      R_ = [x, y, u, v, w],
      Q_ = [p, q],
      C_ = [z],
      Any = [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z],
      "Greek" = [Symbol::alpha, Symbol::beta, Symbol::gamma, Symbol::delta,
               Symbol::varepsilon, Symbol::zeta, Symbol::eta, Symbol::theta, 
               Symbol::iota, Symbol::kappa, Symbol::lambda, Symbol::mu, Symbol::nu, 
               Symbol::xi, Symbol::omicron, Symbol::rho, Symbol::sigma, Symbol::tau,
               Symbol::upsilon, Symbol::varphi, Symbol::chi, Symbol::psi, Symbol::omega]
      ):

solvelib::preferredPrefixes:=
table(
      Z_ = hold(k),
      Q_ = hold(q),
      R_ = hold(x),
      C_ = hold(z),
      Any = hold(t),
      "Greek" = Symbol::theta
      ):

solvelib::setPreferredIdents:=
proc(S, l: DOM_LIST)
begin
  sysassign(solvelib::preferredIdents[S], l)
end_proc:

solvelib::setPreferredPrefix:=
proc(S, x: DOM_IDENT)
begin
  sysassign(solvelib::preferredPrefixes[S], x)
end_proc: