/*    */

// solvelib::getOptions

// return a table of options

// if a table is given as first argument, return this table
// if no argument is given, return the default options
// if some arguments are given, return these as options

solvelib::getOptions:=
() -> prog::getOptions(1, [args()],
                       solvelib::defaultOptions, TRUE,
                       solvelib::optionType)[1];

solvelib::defaultOptions:=
solvelib::originalDefaultOptions:=
table(
   hold(MaxDegree)                 = 2,
   hold(Multiple)                  = FALSE,
   hold(PrincipalValue)            = FALSE,
   hold(BackSubstitution)          = TRUE,
   hold(VectorFormat)              = FALSE,    
   hold(Domain)                    = hold(Expr),
   hold(IgnoreProperties)          = FALSE,
   hold(IgnoreSpecialCases)        = FALSE,
   hold(DontRewriteBySystem)       = FALSE,
   hold(MaxRecLevel)               = 30,
   hold(NoWarning)                 = FALSE,
   hold(Real)                      = FALSE,
   hold(IgnoreAnalyticConstraints) = FALSE,
   hold(DiscontCheck)              = TRUE
):

solvelib::optionType:=
table(
      hold(MaxDegree)                 = DOM_INT,
      hold(Multiple)                  = DOM_BOOL,
      hold(PrincipalValue)            = DOM_BOOL,
      hold(BackSubstitution)          = DOM_BOOL,
      hold(VectorFormat)              = DOM_BOOL,
      hold(Domain)                    = Type::AnyType,
      hold(IgnoreProperties)          = DOM_BOOL,
      hold(IgnoreSpecialCases)        = DOM_BOOL,
      hold(DontRewriteBySystem)       = DOM_BOOL,
      hold(MaxRecLevel)               = DOM_INT,
      hold(NoWarning)                 = DOM_BOOL,
      hold(Real)                      = DOM_BOOL,
      hold(IgnoreAnalyticConstraints) = DOM_BOOL,
      hold(DiscontCheck)              = DOM_BOOL
):

solvelib::nonDefaultOptions:=
proc(t : DOM_TABLE)
  local DONTDISPLAY: DOM_SET;
begin
  DONTDISPLAY:= {DontRewriteBySystem, MaxRecLevel, NoWarning, hold(DiscontCheck),
                 IgnoreProperties, IgnoreSpecialCases, IgnoreAnalyticConstraints};
  op(select([op(t)], eq -> not contains(DONTDISPLAY, op(eq, 1))
             and solvelib::defaultOptions[op(eq,1)]<>op(eq,2)));
end_proc:


solvelib::setOptions:=
() -> sysassign(solvelib::defaultOptions, solvelib::getOptions(args())):

solvelib::restoreDefaultOptions:=
() -> sysassign(solvelib::defaultOptions, solvelib::originalDefaultOptions):
