
/*
solvelib::handlePreImageR(preImageR, sls, a, x, iv, options)

preImageR - set of all values x0 such that a | x=x0 is real
sls - set of all x where a is undefined or equal to a border of iv 
a  - expression
x  - variable
iv - interval
options - table of options (as produced by solvelib::getOptions)

returns the set of all x0 for which a | x=x0 is an element of iv

*/

solvelib::handlePreImageR:=
proc(preImageR: Type::Set, sls, a, x, iv, options)
  local sol, res, i: DOM_INT,
  zeroes, // solutions of the corresponding equation(s)
  handleZeroes: DOM_PROC,
  pt, cond, condleft, condright, newiv, newa, branches, default, IV,
  maxeffort, left, right, leftopen, rightopen,
  poles;

  save MAXEFFORT;
begin

    
  IV:= Dom::Interval;
  
  default:= () ->
            if {IV::left(iv), IV::right(iv)} intersect
              {-infinity, infinity} <> {} then
              hold(solve)(expand(a in iv), x,
                          solvelib::nonDefaultOptions(options)
                          )
            else
              hold(solve)(a in iv, x,
                          solvelib::nonDefaultOptions(options)
                          )
            end_if;




  case type(preImageR)
    of Dom::Interval do
      leftopen:= Dom::Interval::isleftopen(preImageR);
      rightopen:= Dom::Interval::isrightopen(preImageR);
      left:= Dom::Interval::left(preImageR);
      right:= Dom::Interval::right(preImageR);
      break;
    of DOM_SET do
      if preImageR = {} then
        return({})
      else
        res:= {};
        for i from 1 to nops(preImageR) do
          pt:= op(preImageR, i);
          if traperror((cond:= evalAt(a, x= pt) in iv)) = 0 then 
            case is(cond)
              of TRUE do
                res:= res union {pt};
                break      
              of UNKNOWN do     
                res:= res union
                piecewise([cond, {pt}],
                [not cond, {}]
                )
            // of FALSE do: nothing        
            end_case
          // else: if a cannot be evaluated at pt, cond is FALSE 
          end_if
        end_for;
        return(res)
      end_if
    of piecewise do
      branches:= [];
      maxeffort:=MAXEFFORT/2;
      MAXEFFORT:= maxeffort/nops(preImageR);
      for i from 1 to nops(preImageR) do
        cond:= piecewise::condition(preImageR, i);
        newa:= piecewise::subsEqualities(a, cond);
        newiv:= piecewise::subsEqualities(iv, cond);
        if newa <> a or newiv <> iv then
          res:= solvelib::preImage(newa, x, newiv, options)
        else
          res:= solvelib::handlePreImageR(piecewise::expression(preImageR, i),
                                          sls, a, x, iv, options)
        end_if;
        if type(res) = "solve" then
          return(default())
        end_if;
        branches:= branches.[[cond, res]];
      end_for;
      MAXEFFORT:= maxeffort;
      return(piecewise(op(branches)))
    of solvelib::BasicSet do
      if preImageR = R_ then
        leftopen:= rightopen:= TRUE;
        left:= -infinity;
        right:= infinity
      else
        return(default())
      end_if;
      break
    of "_union" do
      sol:= {};
      MAXEFFORT:= MAXEFFORT/nops(preImageR);
      for i from 1 to nops(preImageR) do
        if hastype((res:= solvelib::handlePreImageR
                 (op(preImageR, i), sls, a, x, iv, options)), "solve") then
          return(default())
        else
          sol:= sol union res
        end_if
      end_for;
      return(sol)
    of "_minus" do
      if op(preImageR, 1) = R_ and
        type((zeroes:= op(preImageR, 2))) = DOM_SET
        then
        poles:= solvelib::conditionalSort([op(zeroes)]);
        res:= piecewise::extmap
        (poles,
         proc(l: DOM_LIST)
           save MAXEFFORT;
           local i: DOM_INT;
         begin
           MAXEFFORT:= MAXEFFORT/nops(l);
           solvelib::solve_union
           (
            solvelib::handlePreImageR
            (Dom::Interval(-infinity, l[1]), sls, a, x, iv, options),
            solvelib::handlePreImageR
            (Dom::Interval(l[i], l[i+1]), sls, a, x, iv, options)
            $i=1..nops(l)-1,
            solvelib::handlePreImageR
            (Dom::Interval(l[nops(l)], infinity), sls, a, x, iv, options)
            )
         end_proc
         );
        return(res)
      else
        return(default())
      end_if
    otherwise
      return(default())
  end_case;
  
  assert(type(preImageR) = Dom::Interval or preImageR = R_);

    // use the intermediate value theorem
    // we want to find those x in preImageR that satisfy
    // a(x) in iv
    // hence we have to solve a = IV::left(iv) and a = IV::right(iv)
    // between two adjacent solutions of this, either all or no x 
    // satisfies a(x) in iv

  zeroes:= sls intersect preImageR;
  
  handleZeroes:=
  proc(zeroes)
    local J, critPts, i: DOM_INT;
  begin
    case type(zeroes)
      of piecewise do
        J:= piecewise::extmap(zeroes, handleZeroes);
        if type(J) <> "solve" then
          return(J)
        else
          return(default())
        end_if
      of Dom::Interval do
        zeroes:= {IV::left(zeroes), IV::right(zeroes)} minus
                 {-infinity, infinity};
        break;
      of DOM_SET do
        break
      otherwise
        return(default())
    end_case;
    
    critPts:= solvelib::conditionalSort
    ([op(zeroes union {left, right})]);
      
    if type(critPts) <> DOM_LIST then
      return(default())
    end_if;
    // drop those critical points that have turned out to lie outside the
    // interval
    critPts:= [op(critPts, contains(critPts, left)..
                  contains(critPts, right))];

    sol:= {};
    for i from 1 to nops(critPts) - 1 do
      // decide whether the interval (critPts[i], critPts[i+1])
      // consists of solutions and whether the borders have to be
      // included, too

      J:= Dom::Interval([critPts[i], critPts[i+1]]);
        
      if critPts[i] = -infinity then
        if critPts[i+1] = infinity then
          pt:= 0
        else       
          pt:= critPts[i+1] - 1
        end_if
      elif critPts[i+1] = infinity then
        pt:=  critPts[i] + 1
      else
        pt:= (critPts[i] + critPts[i+1])/2
      end_if;
             
      cond:= evalAt(a, x = pt) in iv;
        
    
      if i=1 then
        if critPts[i] = -infinity or
          leftopen
          or traperror((condleft:= evalAt(a, x = critPts[1]) in iv)) <> 0
          then
          condleft := FALSE
        end_if
      else
        // right border of previous iteration becomes left border
        // of this iteration
        condleft:= condright
      end_if;
      if critPts[i+1] = infinity or
        (i + 1 = nops(critPts) and rightopen)
        or traperror((  condright:= evalAt(a, x = critPts[i+1]) in iv)) <> 0
        then
        condright:= FALSE
      end_if;
      J:= piecewise(
                    [not cond and not condleft and not condright, {}],
                    [not cond and condleft and not condright, {critPts[i]}],
                    [not cond and not condleft and condright, {critPts[i+1]}],
                    [not cond and condleft and condright,
                     {critPts[i], critPts[i+1]}],
                    [cond and not condleft and not condright,
                     IV(critPts[i], critPts[i+1])
                     ],
                    [cond and not condleft and condright,
                     IV(critPts[i], [critPts[i+1]])
                     ],
                    [cond and condleft and not condright,
                     IV([critPts[i]], critPts[i+1])
                     ],
                    [cond and condleft and condright,
                     IV([critPts[i], critPts[i+1]])
                     ]
                    );

      sol:= sol union J
    end_for;
    
    sol
  end_proc;

  handleZeroes(zeroes)
    
end_proc: