//   


// solvelib::ignoreSpecialCases

/* filters the input to a piecewise such
   that all equalities are considered FALSE unless they
   are provably TRUE */

solvelib::ignoreSpecialCases:=
proc()
  option hold;
  local argv, argv1, u, T,  i, cond, result, discarded;
  
begin
  // flatten first. Not necessary if solver does not pass exprseqs 
  argv1:= [args()]; 

  discarded:= [];
  argv:=[];
  i:= 1;
  while i <= nops(argv1) do
    u:= argv1[i];
    T:= type(context(hold(val)(u)));
    if T <> DOM_LIST then  
      error("Argument is not a list")
    end_if;
    cond:= solvelib::specialToFalse(simplify::simplifyCondition(context(u[1])));
    case cond
      of TRUE do
        if traperror((result:= context(u[2]))) = 0 then
          return(result)
        else
          break
        end_if
      of FALSE do
        discarded:= discarded.[u];
        break
      otherwise
        if traperror((result:= context(u[2]))) = 0 then
          argv:=append(argv, [cond, result])
        end_if;
      end_case;
    i:= i+1;  
  end_while;
  if nops(argv) > 1 then
    piecewise(op(argv))
  elif nops(argv) = 1 then
    // omit condition
    op(argv, [1, 2])
  else
    // no branches have survived; let us use the discarded branches
    userinfo(10, "Ignoring special cases would leave no valid branch");
    result:= piecewise(op(map(discarded, context)));
    if result = undefined then
      error("Correctness of result depends on a condition".
            " which is always FALSE")
    end_if;
    result
  end_if
end_proc:
  
