
// solve ineq. in real mode

solvelib::ineqsReal:=
proc(inequation, var: DOM_IDENT, options: DOM_TABLE)
  local ineqtype, makeBorder, S, T, solveCond: DOM_PROC,
  removeXinR: DOM_PROC;
begin

  solveCond:=
  proc(cond)
    local ind, sol;
  begin
    if nops((ind:= indets(cond) minus Type::ConstantIdents)) = 1 then
      sol:= solve(cond, op(ind), options);
      if not hastype(sol, "solve") then
        return(op(ind) in sol)
      end_if;
    end_if;
    cond
  end_proc;


  removeXinR:=
  proc(cond: "_in")
  begin
    if op(cond, 2) = R_ then
      TRUE
    else
      cond
    end_if
  end_proc;
  
  ineqtype:= type(inequation);
  assert(contains({"_less", "_leequal"}, ineqtype));
  makeBorder:= (if ineqtype = "_leequal" then DOM_LIST else id end_if);
  
  if not has(op(inequation, 1), var) then
    S:= solvelib::preImageIntervalReal
           (op(inequation, 2), var,
            Dom::Interval(makeBorder(op(inequation, 1)), infinity), options)
  elif not has(op(inequation, 2), var) then
    S:= solvelib::preImageIntervalReal
           (op(inequation, 1), var,
            Dom::Interval(-infinity, makeBorder(op(inequation, 2))), options)
  else
    // inequality with var on both sides
    S:= solvelib::preImageIntervalReal
    (op(inequation, 2) - op(inequation, 1), var,
     Dom::Interval(makeBorder(0), infinity), options);
    if hastype(S, "solve") then
      return(hold(solve)(inequation, var,
                         solvelib::nonDefaultOptions(options)))
    end_if;
    T:= solvelib::preImage(op(inequation, 1), var, R_, Real);
    if hastype(T, "solve") then
      return(hold(solve)(inequation, var,
                         solvelib::nonDefaultOptions(options)))
    end_if;
    if T <> R_ then
      S:= solvelib::solve_intersect(S, T)
    end_if;
  end_if;

  if type(S) = piecewise then
    piecewise::mapConditions(S, misc::maprec,
                             {"_less", "_leequal"} = solveCond,
                             {"_in"} = removeXinR
                             )
  else
    S
  end_if

end_proc: