
 /*
     isBigSet(S) - auxiliary method to decide whether in piecewise::disregardPoints and 
     solvelib::ignoreSpecialCases,
     "x in S" should be replaced by TRUE, replaced by FALSE, or left unchanged
     This happens independently of x
  */

  solvelib::isBigSet:=
  proc(S)
    local i, sets;
  begin
    case type(S)
      of DOM_SET do
      of RootOf do  
        return(FALSE)
      of solvelib::BasicSet do
        if S=R_ then
          return(UNKNOWN)
        end_if;
        return(bool(S=C_))
      of "_union" do
        return(_or(solvelib::isBigSet(op(S, i)) $i=1..nops(S)))
      of "_intersect" do
        return(_and(solvelib::isBigSet(op(S, i)) $i=1..nops(S)))
      of "_minus" do
        return(solvelib::isBigSet(op(S, 1)) and not solvelib::isBigSet(op(S, 2)))
      of Dom::ImageSet do
        sets:= S::dom::sets(S);
        return(_or(solvelib::isBigSet(op(sets, i)) $i=1..nops(sets)))
    end_case;
    UNKNOWN
  end_proc;
