
/* solvelib::isEmpty(S)

   returns a logic expression that is equivalent to S={}

*/


solvelib::isEmpty:=
proc(S)
  local i: DOM_INT, j:DOM_INT, l, s, intervals, others, dummy, left, right;
begin
  if args(0) = 0 then 
    error("solvelib::isEmpty called without argument")
  end_if;

  if S::dom::isEmpty <> FAIL then
    return(S::dom::isEmpty(S))
  end_if;
  
  if not testtype(S, Type::Set) then
    error("Illegal argument")
  end_if;

  case type(S)
    of DOM_SET do
      return(bool(S={}))
    of RootOf do
      return(_and(coeff(op(S, 1), [op(S, 2)], i) = 0
                  $i=1..degree(op(S, 1), [op(S, 2)]))
             and
             coeff(op(S, 1), [op(S, 2)], 0) <> 0)
    of "_union" do
      return(_and(solvelib::isEmpty(op(S, i)) $i=1..nops(S)))
    of "_intersect" do
      l:= [op(S)];
      if ((i:= contains(map(l, domtype), DOM_SET))) > 0 then
        s:= l[i];
        delete l[i];
        if nops(l) > 1 then
          l:= hold(_intersect)(op(l))
        else
          l:= l[1]
        end_if;
        return(not _or((op(s, j) in l) $j=1..nops(s)))
      end_if;
      l:= {op(l)};
      [intervals, others, dummy]:= split(l, x -> type(x) = Dom::Interval);
      assert(dummy = {});
      if others = {Z_} then
        left:= max(map(intervals, iv -> iv::dom::left(iv)));
        right:= min(map(intervals, iv -> iv::dom::right(iv)));
        if is(left > right) = TRUE then
          return(TRUE)
        end_if;
        if right = infinity or left = -infinity or is(right - left > 1) = TRUE then
          return(FALSE)
        end_if;
      end_if;
      break
    of "_minus" do
      return(op(S, 1) subset op(S, 2) )
  end_case;

  procname(args())
  
end_proc:

solvelib::isEmpty:= funcenv(solvelib::isEmpty):

solvelib::isEmpty::type:= "isEmpty":

solvelib::isEmpty::testtype:=
proc(x, T)
begin
  if T = Type::Arithmetical then 
    FALSE
  else 
    FAIL
  end_if
end_proc:

solvelib::isEmpty::float:=
proc(S)
begin
  solvelib::isEmpty(float(S))
end_proc:

/* end of file */
