/*--
	solvelib::solve_isalgebraic

	returns FALSE if sys is not an algebraic system with respect 
	to unk, otherwise
   [sys, denominators] where all equalities a=b have been 
	replaced by a-b and all 0 equations have been deleted in sys,
   and denominators contains all denominators

   Parameters:

   sys -  set or list of equations or arithmetical expressions
     u - set or list of identifiers

--*/

solvelib::solve_isalgebraic :=
proc(sys, unk)
  local i, eq, den, denominators, numerators, d, l;
begin
  denominators:= {};
  den := 1;
  numerators:= [FAIL $nops(sys)]; // allocate memory
  for i from 1 to nops(sys) do
    eq:= op(sys, i);
    l:= normal(eq, List, Expand = FALSE);
    d:= l[2];
    numerators[i]:= l[1];
    if not testtype(numerators[i], Type::PolyExpr([op(unk)])) then
      return(FALSE)
    end_if;  
    den:= den * d;
    denominators:= denominators union {d}
  end_for;
  if not testtype(den, Type::PolyExpr([op(unk)])) then
    return(FALSE)
  end_if;

  

  // regard also polynomials of very large degree as non-algebraic
  if max(map(numerators, degree)) >= Pref::autoExpansionLimit() then
     return(FALSE)
  end_if;

    // zeroes of the denominator cannot be solutions, we may divide
    // them off 
  
  [map(numerators,
      proc(eq)
        local g;
      begin
        // it may happen that the division reveals that eq is zero, 
        // which we haven't detected before
        while not iszero(eq) and degree((g:= gcd(eq, den)), unk) > 0 do
          eq:= divide(eq, g, unk, Exact)
        end_while;
      eq
      end_proc
      ), denominators]
end_proc:

/* end of file */

