
// numberSetToVectorSet
// implements the isomorphism between S and solvelib::cartesianPower(S, 1)


solvelib::numberSetToVectorSet:=
proc(S)
  local newex;
begin
  case type(S)
    of DOM_SET do
      return(map(S, matrix@DOM_LIST))
    of Dom::ImageSet do
      newex:= matrix([expr(S)]);
      return(solvelib::VectorImageSet(newex, S::dom::variables(S),
                                      S::dom::sets(S) ))
    of piecewise do
      return(piecewise::extmap(S, solvelib::numberSetToVectorSet))
    of "_union" do
    of "_intersect" do
    of "_minus" do  
      return(map(S, solvelib::numberSetToVectorSet))
  end_case;

  // default:
  solvelib::cartesianPower(S, 1)
  
end_proc: