/* 
 solvelib::pdioe(a, b, c, x)

 a, b, c - polynomials or polynomial expressions (in x)

 returns s, t with s*a + t*b = c if such s, t exist
 s, t are chosen such that the degree of t is as small as possible

*/
solvelib::pdioe:= 
proc(a, b, c, x)
  local s, t, u, v, g, q, r, ex;
begin
  if args(0) = 0 then
    error("solvelb::pdioe called without arguments")
  end_if;
  
  if a::dom::pdioe <> FAIL then 
    return(a::dom::pdioe(args())) 
  end_if;
  
  // argument checking
  
  if args(0) < 3 or args(0) > 4 then
    error("Wrong number of arguments in pdioe")
  end_if;  
  
  if type(a) = DOM_POLY then
    if type(b) <> DOM_POLY or type(c) <> DOM_POLY then
      error("Either all or no arguent must be polynomials")
    end_if;
    
    if nops({op(a, 2), op(b, 2), op(c, 2)}) <> 1 then
      error("All polynomials must be in the same variable")
    end_if;
    
    if nops({op(a, 3), op(b, 3), op(c, 3)}) <> 1 then
      error("All polynomials must have the same coefficient ring")
    end_if;
    
    if nops(op(a, 2)) <> 1 then 
      error("Polynomials must be univariate")
    end_if;
    
    if args(0) = 4 then
      if op(a, [2, 1]) <> x then
        error("Can only solve for polynomials in the same indeterminate the input polynomials have")
      end_if
    else
      x:= op(a, [2, 1])
    end_if;  
    
    ex:= id;
  
  else
    // input consists of expressions
    if args(0) < 4 then
      error("Variable missing")
    end_if;  
    
    ex:= expr;
    a:= poly(a, [x]);
    b:= poly(b, [x]);
    c:= poly(c, [x]);
  
    if a = FAIL or b = FAIL or c = FAIL then
      error("Input must consist of polynomoals or polynomial expressions")
    end_if;  
    
  end_if;
  [g, s, t]:= [gcdex(a, b)];  
  // now g = gcd(a, b), s*a + t*b = g
  // however, not syntactically, such that the following assertion will not work:
  // assert(s*a + t*b = g);  
  [q, r]:= [divide(c, g)];
  if not iszero(r) then
    return(FAIL)
  end_if;
  // q*s*a + q*t*b = c
  // however, q*s and q*t may not be smallest possible
  // we divide q*t by a with remainder, q*t = u*a + v
  // then
  // c = q*s*a + q*t*b = q*s*a + u*a*b + v*b = (q*s+u*b)*a + v*b
  [u, v]:= [divide(q*t, a)];
  ex(q*s + u*b), ex(v)
end_proc:
   
/* end of file */
