/*--
	solvelib::solve_poly_irred

   solve irreducible polynomials and polynomials we did not want to factor

--*/

solvelib::solve_poly_irred :=
proc(p,x) /* p is irreducible */
  local a,b,c,d,f,l,l2, s, yy, dummy,
  lev:DOM_INT,
  multi: DOM_BOOL,
  options: DOM_TABLE,
  // flattenSets: DOM_PROC,
  checkCyclotomic:  DOM_PROC,
  solve_inner: DOM_PROC,
  halveExponent: DOM_PROC,
  baseSet: solvelib::BasicSet,
  pw;

  save MAXEFFORT;
  
begin

  // local method checkCyclotomic
  // returns n where f is the n-th cyclotomic polynomial, and FAIL if no such n exists

  checkCyclotomic:=
  proc(f)
    local l, i, cond;
  begin
    if lcoeff(f) <> 1 then
       return(FAIL)
    end_if;
    l:= numlib::invphi(degree(f));
    cond:= bool({coeff(f)} minus {0, -1, 1} = {});
    // if cond is FALSE, f cannot be an i-th cyclotomic polynomial for small i 
    for i in l do 
	if (cond or i >= 105) and divide(poly(x^i - 1), f, Exact) <> FAIL then
         return(i)
      end_if
    end_for;
    FAIL
  end_proc;



  options:=solvelib::getOptions(args(3..args(0)));
  lev:=options[MaxDegree];
  multi:=options[Multiple];
  pw:= if options[IgnoreSpecialCases] or options[IgnoreAnalyticConstraints] then
         solvelib::ignoreSpecialCases
       else
         piecewise::new
       end_if;

  if options[Real] then
    baseSet:= R_
  else
    baseSet:= C_
  end_if;
  
  d:=degree(p,x);
  userinfo(2,"solving irreducible polynomial of degree ".expr2text(d));
  userinfo(10, "Polynomial is ".expr2text(p));
  userinfo(10, "Variable to solve for: ".expr2text(x));
  userinfo(10, "Options are ".expr2text(op(options)));
  if multi then
    s:=Dom::Multiset
  else
    s:=DOM_SET
  end_if;
  if d=0 then
    expr(coeff(p,x,0));
    // multi: deliver an error instead of C_ (or R_) ?
    pw([%=0, baseSet],[%<>0, {}])
  elif d = 1 then
    if op(p,2) = [x] then
      l:= -coeff(p, x, 0);
      d:= coeff(p, x, 1)
    else
      l:= -expr(coeff(p, x, 0));
      d:= expr(coeff(p, x, 1))
    end_if;
    // we are solving d*x - l = 0, so
    // x = l/d is the solution
    // we might try to simplify l/d ?!
    case traperror((f:= normal(l/d, Recursive = FALSE)))
      of 0 do
        break;
      of 260 do
      of 1025 do
        // Division by zero -> d was zero
        return(pw([l=0, baseSet],[l<>0, {}]))
      of 1040 do 
        // exponent overflow
        f:= l/d;
        break
      otherwise
        // do not catch other errors
        lasterror()
    end_case;
    if length(f) >= length(l/d) then
      f:= l/d
    end_if;
    MAXEFFORT:= min(MAXEFFORT, 2000);
    pw([d<>0, s(f)],
       [d=0 and l=0, baseSet],
       [d=0 and l<>0, {}])
  elif d = 2 and lev >= 2 then
    a:=coeff(p,x,2);
    b:=coeff(p,x,1);
    c:=coeff(p,x,0);
    if op(p,2)<>[x] then
      a:=expr(a); b:=expr(b); c:=expr(c)
    end_if;

    d:= b^2 - 4*a*c;
    l:= length(d);
    if not contains({DOM_INT, DOM_RAT}, type(d)) and MAXEFFORT > 20*l then
      traperror((d:=expr(factor(expand(d), MaxDegree = 1))), MaxSteps = 5);
      MAXEFFORT:= MAXEFFORT - 10*l
    end_if;

    if options[Real] then
      MAXEFFORT:= MAXEFFORT/4;
      return(
      pw([a=0 and b=0 and c=0, baseSet],
         [a=0 and b=0 and c<>0 or a<>0 and d<0, {}],
         [a=0 and b<>0, s(normal(-c/b))],
         [a<>0 and d>=0, s(normal((-b+sqrt(d))/2/a),normal((-b-sqrt(d))/2/a))])
             )
    end_if;
    
    /* if d=X*Y^2 we can choose the square root d=X^(1/2)*Y which is prettier
       in most cases  
       the same if d = X * exp(2*Y): choose d=X^(1/2)*exp(Y)
       Cf. also the function specfunc::Wurzelbehandlung
    */

    halveExponent:=
    proc(pow: Type::Union("_power", "exp"))
    begin
      if type(pow) = "_power" then
        op(pow, 1)^(op(pow,2)/2)
      else
        exp(op(pow, 1)/2)
      end_if
    end_proc;
    

    if type(d) = "_power" and type((l:=op(d, 2)/ 2)) = DOM_INT then
      d:= op(d, 1)^l
    elif type(d) = "_mult" then
      [l, l2, dummy] := split([op(d)],
                             proc(fctor)
                               begin
                                 (type(fctor) = "_power" and
                                 type(op(fctor, 2)/2) = DOM_INT)
                                 or
                                 type(fctor) = "exp"
                             end_proc
                             );
      if nops(l) > 0 then
        d:= _mult(op(map(l, halveExponent))) * sqrt(_mult(op(l2)))
      else
        d:= sqrt(d)
      end_if
    else
      d:= sqrt(d)
    end_if;


    case is(b=0)
      of TRUE do
        pw([a=0 and c=0, baseSet],
                 [a=0 and c<>0, {}],
                 [a<>0, s(normal((-b+d)/2/a), normal((-b-d)/2/a))]);
        break
      of UNKNOWN do
        if not options[IgnoreSpecialCases] then
        // to avoid division by zero 
          pw([a=0 and b=0 and c=0, baseSet],
                 [a=0 and b=0 and c<>0, {}],
                 [a=0 and b<>0, s(normal(-c/b))],
                 [a<>0, s(normal((-b+d)/2/a),normal((-b-d)/2/a))]);
          break
          // else handle as FALSE and fall through
        end_if;
        
      of FALSE do 
         pw(
            [a=0, s(normal(-c/b))],
            [a<>0, s(normal((-b+d)/2/a),normal((-b-d)/2/a))]
            );
         break
    end_case
  elif d=3 and lev>=3 then
    pw([coeff(p,x,3)=0, solvelib::solve_poly(divide(p, poly(x^3),
                                                    hold(Rem)), x, options) ],
       [coeff(p,x,3)<>0, solvelib::solve_poly3(p,x,options)  ])
  else /* d>=4 */

    l:= poly2list(p);
    // check whether the input is a cyclotomic polynomial
    if {op(map(map(l, op, 1), type))} = {DOM_INT} and
       type((b:= checkCyclotomic(p))) = DOM_INT then
       // all b-th primitive roots of unity are solutions     
       c:= select([$1..b-1], n -> igcd(n, b) = 1);
       return(s(exp(2*a*PI*I/b) $a in c))  
    end_if;

    // before calling polylib::decompose, find out the gcd of exponents:
    // if it is greater than 1, we get an obvious decomposition
    /* still l = poly2list(p) */
    a:= igcd(op(map(l, op, 2)));
    if a > 1 then
      // p is a polynomial in x^l, p = f(x^l) for some f
      // thus, p(x) = 0 iff f(x^l) = 0 iff x^l = y for some solution y
      // of f(y) = 0
      f:= map(l, term -> [op(term, 1), op(term,2) div a]);
      f:= poly(f, [x]);
      b:= solvelib::solve_poly_irred(f, x, options);
      yy:= solvelib::getIdent(C_, indets(x));
      c:= solvelib::solve_eq(yy^a - x, yy, options);
      d:= genident("z");
      return(solvelib::Union(evalAt(c, x=d), d, b))
    end_if;
    userinfo(1,"trying polynomial decomposition");
    /* do not try decomposition if lev=1 */
    if lev<2 or degree(p) >= Pref::autoExpansionLimit() or nops((a:=[polylib::decompose(p,x)]))=1 then
/* no decomposition */
      userinfo(1,"decomposition failed");
      // our polynomial cannot be x^d or x^d + a; for, in that case, it would have been decomposable or reducible
      assert(nterms(p) > 2);
      if d=4 and lev>=4 then
         pw([coeff(p,x,4)=0, solvelib::solve_poly(divide(p, poly(x^4),
                                                    hold(Rem)), x, options)],
            [coeff(p,x,4)<>0, solvelib::solve_poly4(p,x,options)  ])
      elif hastype((a:=expr(p)),DOM_FLOAT) and
        indets(a)={x} then
        if options[Real] then
          s(op(select(numeric::polyroots(p), numeric::isreal)))
        else
          s(op(numeric::polyroots(p)))
        end_if
      else
        userinfo(5, "Cannot solve by radicals");
        c:= solvelib::getIdent(C_, indets(a));
        if options[Real] then
          RootOf(evalAt(a, x=c),c) intersect R_
        else
          RootOf(evalAt(a, x=c),c)
        end_if
      end_if
    else
      userinfo(1,"decomposition succeeded");
      userinfo(5,"decomposed input into ".expr2text(nops(a)).
               " polynomials");

      // now a=[f1,..,fk]
      // This means we have to solve f1(f2(...(x)..))=0 for x
      // start by solving f1(y)=0 for y; for each solution y,
      // solve f2(z)=y for z, and so on
      
      b:=solvelib::solve_poly(a[1],x,options);
      delete a[1];
      for f in a do
        // we have solved f1(f2(..f_{i-1}(y)..))=0; the solutions
        // are stored in b . For each such solution y, we now have to solve
        // f(x) = y and store all of these x in b.
        

        // piecewise - case: uncommented because of efficiency problems
        
        if type(b)<>s /* and type(b)<>piecewise */ then
          /* cannot solve innermost -> return a RootOf */
          if d = 4 then
            return(pw([coeff(p,x,4)=0,
                       solvelib::solve_poly(divide(p, poly(x^4),
                                                   hold(Rem)), x, options)],
                      [coeff(p,x,4)<>0,
                       solvelib::solve_poly4(p,x,options)  ]))
          else
            
            c:= solvelib::getIdent(C_, indets(expr(p)));
            if options[Real] then
              return(RootOf(evalAt(expr(p), x=c), c) intersect R_)
            else  
              return(RootOf(evalAt(expr(p), x=c), c))
            end_if
          end_if;
        end_if;

        // b may be a set or a piecewise of sets of y's
        // we map a function that returns, for each y,
        // the set of solutions of f(x)=y
        
     
                             
        solve_inner:=
        proc(S)
          local solve_el;

        begin
          
          solve_el:=
          proc(y)
            local g;
          begin
            g:=f-poly(y, [x]);
            userinfo(10, "Polynomial to solve:".
                     expr2text(g));
            g:=solvelib::solve_poly(g, x, options);
            userinfo(10,"Set of solutions is ".
                     expr2text(g));
            g
          end_proc;

          case type(S)
            of piecewise do
              map(S, solve_inner); break
            of DOM_SET do
            of Dom::Multiset do  
              Dom::Multiset::nestedUnion(map(S, solve_el)); break
            of solvelib::BasicSet do
              // S=C_
              // but g(x) in C_ is true for every x anyway
              S; break
            otherwise
              error("Unknown type of solution ".expr2text(S))
          end_case;

        end_proc;
              

        b:= solve_inner(b);

        if type(b)=piecewise then 
          b:=simplify(b) 
        end_if;          
         
      
      end_for;
      userinfo(5, "Return value is ".expr2text(b));
      b
    end_if
  end_if
end_proc:

/* end of file */


