/*    */


/* solvelib::preImage(eq, x, S)

   determine the set of all C such that subs(eq, x=C) is an
   element of S
   S must *not* depend on x

*/

alias(BOUND = 10):


solvelib::preImage:=
proc(eq: Type::Arithmetical, x: DOM_IDENT, S: Type::Set)
local i, options: DOM_TABLE, v, k, sol, preim: DOM_PROC, propset,
  isolate: DOM_PROC, pw;
  
save MAXEFFORT;

begin

  // local method for computing the preimage of a particular set
  // under the given mapping
  preim:= u-> solvelib::preImage(eq, x, u, options):


  // local method isolate
  // transforms eq in S by making eq simpler (and S more complicated)
  // returns NIL, or the preimage if that can be computed directly
  
  isolate:=
  proc()
    local l, S2, change: DOM_BOOL;
  begin
    repeat
      change:= FALSE;
      case type(eq)
        of "_plus" do
          if S=Z_ then
            l:= select(eq, u -> not is(u in Z_, Goal = TRUE));
            if eq <> l then
              eq:= l;
              change:= TRUE;
              break
            end_if
          end_if;
          l:= split(eq, has, x);
          if not iszero(l[2]) then
            S:= S - l[2];
            eq:= l[1];
            change:= TRUE
          end_if;
          break
        of "_mult" do
          l:= split(eq, has, x);
          if l[2] <> 1 then 
            if is(l[2] <>0, Goal = TRUE) then  
              S:= S* (1/l[2]);
              eq:= l[1];
            else
              // case analysis: if l[2] = 0, then eq=0; so either 0 in S or not
              return(pw([l[2] = 0, solvelib::preImage(0, x, S, options)],
                        [l[2] <> 0, solvelib::preImage(l[1], x, S*(1/l[2]), options)]
                       )
                    )         
            end_if;
            change := TRUE
          end_if;
          break
        of "ln" do
          if is(x>0, Goal = TRUE) then
            S2:= S intersect R_;
            if S <> S2 and type(S2) <> "_intersect" then
              S:= S2;
            end_if
          end_if;
          break;
        of "sin" do
        of "cos" do
          // for real variables, we may intersect the right hand side
          // with [-1, 1]
          if is(x in R_, Goal = TRUE) then
            S2:= S intersect Dom::Interval([-1, 1]);
            if S <> S2 and type(S2) <> "_intersect" then
              S:= S2;
            end_if
          end_if;
          break
      end_case
    until not change or type(S) <> Dom::ImageSet and S<>Z_ end_repeat;
    NIL 
  end_proc;
    
  
  
  if testargs() then
    if contains(freeIndets(S), x) then
      error("Third argument must not depend on variable")
    end_if;
  end_if;

  options:=solvelib::getOptions(args(4..args(0)));
  
  if type(eq) = piecewise then
    // simple case: conditions do not depend on x
    if not has(piecewise::conditions(eq), x) then 
      return(piecewise::extmap(eq, solvelib::preImage, x, S, options))
    end_if;
    // eq(x) = eq1(x) if cond1(x), eq2(x) if cond2(x) ...
    // then eq(x) in S iff for some k, condk(x) and eqk(x) in S 
    return(solvelib::solve_union
           (solvelib::solve_intersect
            (solve(piecewise::condition(eq, i), x, options),
             solvelib::preImage(piecewise::expression(eq, i), x, S, options)
             )
            $i=1..nops(eq)
           )
           )
  end_if;
  

  if options[Real] then
    for v in freeIndets(eq) do
      assumeAlso(v in R_)
    end_for
  end_if;

  if S::dom::preImage<>FAIL then
    return(S::dom::preImage(args()))
  end_if;

  if options[IgnoreSpecialCases] or options[IgnoreAnalyticConstraints] then
    pw:= solvelib::ignoreSpecialCases
  else
    pw:= piecewise::new
  end_if;

  if not has(eq, x) then
    // either eq in S anyway or not - this does not depend on x
    if options[IgnoreProperties] then
      return(pw([eq in S, C_], [not eq in S, {}]))
    else 
    	return(pw([eq in S, getprop(x, "DisAllowed" = {Dom::ImageSet, piecewise})], [not eq in S, {}]))
    end_if;
  end_if;
  if eq=x then
    if options[IgnoreProperties] then
      return(S)
    else
      sol:= solvelib::solve_intersect(S, getprop(x, "DisAllowed" = {Dom::ImageSet, piecewise}));
      return(sol)
    end_if
  end_if;
  case type(S)
    of DOM_SET do
      if nops(S) = 0 then
        return({})
      end_if;
      if nops(S) <= BOUND then
        MAXEFFORT:= MAXEFFORT/nops(S);
        sol:= _union
               (
                // use defaults for reclevel and known
                solvelib::isolate(eq, op(S,i), x, options)
                $i=1..nops(S)
                );
        if property::hasprop(x) and not options[IgnoreProperties] then
          propset:= solve(_and(op(property::showprops(x))), x, options);
          return(sol intersect propset)
        else
          return(sol)
        end_if
      else
        break
      end_if;
    of piecewise do
      return(piecewise::extmap(S, preim))
    of "_union" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      return(solvelib::solve_union(op(map([op(S)], preim))))
    of "_intersect" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      return(solvelib::solve_intersect(op(map([op(S)], preim))))
    of "_minus" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      return(solvelib::solve_minus(op(map([op(S)], preim))))
    of "Union" do
      MAXEFFORT:= MAXEFFORT/2;
      S:= solvelib::avoidAliasProblem(S, indets(eq, All));
      sol:= solvelib::preImage(eq, x, op(S,1), options);
      sol:= solvelib::avoidAliasProblem(sol, indets({op(S, 2..3)}));
      return(solvelib::Union(sol,
                             op(S, 2), op(S, 3)
                             ))
    of Dom::ImageSet do
      S:= solvelib::avoidAliasProblem(S, indets(eq, All));
      // move constants into the image set etc.
      sol:= isolate();
      if sol <> NIL then return(sol) end_if;
      if type(S) <> Dom::ImageSet then
        return(solvelib::preImage(eq, x, S, options))
      end_if;
      
      // S = { f(y); y \in A }
      // then eq(x) \in S iff eq(x)=f(y) for some y in A
      // but first take care of the alias problem x=y
      if S::dom::nvars(S)=1 then
        // try getprop - heuristic first
        sol:= getprop(eq, "DisAllowed" = {Dom::ImageSet, piecewise}) intersect S;
        if type(sol) = DOM_SET then
          return(solvelib::preImage(eq, x, sol, options))
        end_if;
        v:= solvelib::getIdent(C_, indets({eq, S}));
        // own effort is roughly 100
        if MAXEFFORT > 100 then
          MAXEFFORT:= MAXEFFORT - 100
        end_if;
        k:= op(S::dom::variables(S), 1);
        if MAXEFFORT > 10 then 
          sol:= solve(eq=subs(expr(S), k=v), x, options)
              assuming v in S::dom::sets(S)[1]
        else
          sol:= hold(solve)(eq=subs(expr(S), k=v), x, solvelib::nonDefaultOptions(options))
        end_if;
        return(solvelib::Union(sol, v,
                               op(S::dom::sets(S), 1)
                               ))
      else
        break
      end_if
    of solvelib::BasicSet do
      case S
        of C_ do
          return(S minus discont(eq, x, undefined))
        of R_ do
          return(solvelib::preImageReal(eq, x, options))
        of Z_ do
          isolate();
          if S<>Z_ then
            return(solvelib::preImage(eq, x, S, options))
          end_if;
          break
          // continue by solving below
          // otherwise
          // fall through
      end_case;
  end_case;


  // try getprop
  sol:= getprop(eq, "DisAllowed" = {Dom::ImageSet, piecewise})  intersect S;
  if type(sol) = DOM_SET and (type(S) <> DOM_SET or nops(sol) < nops(S)) then
    return(solvelib::preImage(eq, x, sol, options))
  end_if;
  
  
  v:= solvelib::getIdent(C_, indets({eq, S}));
 
  // for each of the following steps, reserve one half of the time
  MAXEFFORT:= MAXEFFORT/2;
  sol:= solve(eq=v, x, options) assuming v in S;
  solvelib::avoidAliasProblem
  (solvelib::Union(sol, v, S), {x})
end_proc:


// special case S = R_: determine all x such that f(x) is real

solvelib::preImageReal:=
proc(eq, x, options)
  local zeroes, fac, rf;
  save MAXEFFORT;
begin
  // simple test
  // do not use is(..) because of bugs
  if simplify::simplifyCondition(eq in R_, UseSolver=FALSE) = TRUE then
    return(getprop(x))
  end_if;


  case type(eq)
    of  "_power" do
      if type(op(eq, 2)) = DOM_RAT then
        if op(eq, 2) > 0 then
          return(solve(op(eq, 1) >= 0, x) )
        else
          return(solve(op(eq, 1) > 0, x) )
        end_if
      end_if;
      break
    of "ln" do
      // ln(f(z)) in R_ iff f(z) is positive
      return(solve(op(eq, 1) > 0, x))
    of "arcsin" do
    of "arccos" do
      // arcsin(f(z)) in R_ iff f(z) \in [-1, 1], the same for arccos
      return(solvelib::preImage(op(eq, 1), x, Dom::Interval([-1, 1]), options))
    of "exp" do
      if options[Real] or options[IgnoreAnalyticConstraints] then
        return(solvelib::preImageReal(op(eq, 1), x, options))
      else
        return(solvelib::preImage(Im(op(eq, 1))/PI, x, Z_, options))
      end_if
    of "lambertW" do
      return(
             solve(op(eq, 1) = -1, x, options) intersect
             solvelib::preImage(op(eq, 2), x, Dom::Interval(-1/exp(1), 0),
                                options)
             union
             solve(op(eq, 1), x, options) intersect
             solve(op(eq, 2) >= -1/exp(1), x, options)
             )
    of "_plus" do
      eq:= select(eq, s -> is(s in R_) <> TRUE);
      if type(eq) <> "_plus" then
        return(solvelib::preImageReal(eq, x, options))
      else
        break
      end_if
    of "_mult" do
      zeroes:= split([op(eq)], s -> is(s in R_) <> TRUE);
      assert(nops(zeroes[3]) = 0);
      if nops(zeroes[2]) = 0 then
        // there are no real factors to divide off
        break
      end_if;
      // there are real factors; eq is zero iff the product of the other
      // factors is real or if one of the real factors is zero
      eq:= _mult(op(zeroes[1]));
      MAXEFFORT:= MAXEFFORT/nops(zeroes[2]);
      return(solvelib::preImageReal(eq, x, options) union
             _union(solve(fac, x, options) $fac in zeroes[2]))
  end_case;


  if MAXEFFORT < 2000 then
    return(hold(solve)(Im(eq), x))
  end_if;

  // last resort:
  rf:= rectform(eq);
  MAXEFFORT:= MAXEFFORT - 1000;
  if op(rf, 3) <> 0 then
    hold(solve)(Im(eq), x)
  else
    rf:= op(rf, 2);
    // take care that no Re(X) + I*Im(X) remains
    rf:= eval(subsex(rf,
                (Re(fac) + I*Im(fac) = fac,
                 Re(fac)^2 + Im(fac)^2 = abs(fac)^2)
                $fac in indets(eq)));
    solve(rf, x, options)
  end_if
end_proc:



unalias(BOUND):
