
/*
solvelib::preImageInterval(a, x, iv, options)
-  a: arithmetical expression
-  x: identifier
-  iv: interval
- options: table of options as returned by solvelib::getOptions

returns the set { x in C_; a(x) in iv }
*/


solvelib::preImageInterval:=
proc(a, x, iv: Dom::Interval, options: DOM_TABLE)
  local mapB: DOM_PROC, default: DOM_PROC,
  polyInIv: DOM_PROC,
  CxInIv: DOM_PROC,
  preImageIVP: DOM_PROC,
  preImageIVN: DOM_PROC,  handleIV: DOM_PROC,
  preImageR: TypeSet,
  k, nl, nr, z,
  l, r, lb, rb, // left and right border
  ivp: Type::Set,
  ivn: Type::Set,
  IV, reals, others, dummy,
  sol, sls, base, expo,
  inds: DOM_SET,
  X: DOM_IDENT;
  save MAXEFFORT;
  
begin

  // mapB - a useful utility function
  mapB:= proc(b, f)
         begin
           if type(b) = DOM_LIST then
             [f(op(b, 1), args(3..args(0)))]
           else
             f(b, args(3..args(0)))
           end_if
         end_proc;

  default:= () ->
            if {IV::left(iv), IV::right(iv)} intersect
              {-infinity, infinity} <> {} then
              hold(solve)(expand(a in iv), x,
                          solvelib::nonDefaultOptions(options)
                          )
            else
              hold(solve)(a in iv, x,
                          solvelib::nonDefaultOptions(options)
                          )
            end_if;


  // given a constant C, returns the set s of all y with C*y in iv
  /*
     CxInIv(C, others, iv, options)
     C - constant independent of x
     others - a function of x. We finally want to find those 
              values of x such that others(x) in s; thus we are solving for a variable 
              y that has the same properties as others(x)
     iv - set (usually an interval)
     options - table of options

  */
  CxInIv:=
  proc(C, others, iv, options)
    local divC;
  begin
    if type(iv) <> Dom::Interval then
      solvelib::preImage(C*x, x, iv, options) 
    elif is(others in R_) = TRUE then
      // C*x in iv iff C=0 and 0 in iv or x=0 and 0 in iv or
      // C real and x in iv/C
      divC:= (x, C) -> if x=-infinity or x=infinity then x else x/C end;
      piecewise([C = 0 and 0 in iv, R_],
                [not C in R_ and 0 in iv, {0}],
                [(C= 0 or not C in R_) and not 0 in iv, {}],
                [C > 0, IV::mapBorders(iv, divC, C)],
                [C < 0, IV::mapBorders(-iv, divC, -C)]
                )
    else  
      piecewise([C = 0 and 0 in iv, C_],
                       [C = 0 and not 0 in iv, {}],
                       [C <> 0, IV::mapmultparam(iv, 1/C)]
                )
    end_if
  end_proc;

  polyInIv:=
  proc(f, x, iv, options)
    local a, b, c, i;
  begin
    case degree(f, x)
      of 1 do
        // can have been caused by an implicit collect;
        // normally, this should be handled below
        return(solvelib::preImage(coeff(f, x, 1)*x, x, iv - coeff(f, x, 0),
                                  options)
               )
      of 2 do
        // a*x^2 + b*x + c in iv can be reduced to a=0 or
        // x^2 + B*X + C in iv/a with B=b/a, C=C/a
        // which is equivalent to (x+B/2)^2 in iv/a + (B^2/4 - C)
        [c, b, a]:= [coeff(f, x, i) $i=0..2];
        return(piecewise
               ([a = 0, CxInIv(b, x, iv-c, options)],
                [a <> 0, 
                 solvelib::preImage
                 ((x+b/a/2)^2, x,
                  IV::mapmultparam(iv, 1/a) + ((b/2/a)^2 - c/a),
                  options
                  )
                 ]
                )
               )
     
    end_case;
    hold(solve)(f in iv, x, solvelib::nonDefaultOptions(options))
  end_proc;


 
  
   
  if not has(a, x) then
    return(piecewise([a in iv, C_], [not a in iv, {}]))
  end_if;
  

  if protected(x) <> None then
    k:= genident("x");
    a:= subs(a, x=k);
    x:= k
  end_if;

  // extract content
  if (type(a) = "_mult" and contains({DOM_INT, DOM_RAT}, type((k:= op(a, nops(a))))))
    or
    (type(a) = "_plus" and traperror((k:= content(a))) = 0 and
     k<>1 and k<>FAIL) then
    if iszero(k) then
      // this may happen: we have recognized at this point that a=0
      return(piecewise([0 in iv, C_], [not 0 in iv, {}]))
    end_if;
    a:= a/k;
    iv:= iv/k;
  end_if;
 
  IV:= Dom::Interval;
  [l, r]:= IV::borders(iv);
  lb:= IV::leftB(iv);
  rb:= IV::rightB(iv);


 
  case type(a)
    of DOM_IDENT do
      assert(a = x);
      return(iv)
    of "_plus" do
      reals:= select(a, s -> not has(s, x));
      if not iszero(reals) and is(reals in R_, Goal = TRUE) then
        return(solvelib::preImage(a - reals, x, iv - reals, options))
      else
        break
      end_if;
    of "_mult" do
      [reals, others, dummy]:= split(a, s -> not has(s, x));
      if reals <> 1 then
        // we have to solve reals * others(x) in iv for x
        // first solve 
        if others = x then 
          return(CxInIv(reals, others, iv, options))
        else
          sol:= CxInIv(reals, others, iv, options);
          // do not handle too complicated solutions here
          if piecewise::extmap(sol, s -> 
            if contains({DOM_SET, Dom::Interval, solvelib::BasicSet},  type(s)) then
              TRUE
            else
              FALSE
            end_if) = TRUE then   
            return(solvelib::preImage(others, x, sol,
            options))
          end_if  
        end_if                          
      end_if;
      break
    of "_power" do
      [base, expo]:= [op(a)];
      // inequalities with constant exponent, f(x)^C in iv
      if not has(expo, x) then
        if stdlib::hasmsign(expo) then
          return(solvelib::preImage(base^(-expo), x, 1/iv, options))
        end_if;
        case type(expo)
          of DOM_INT do
            assert(expo > 0);
            // split iv into a positive and a negative part ivp and ivn
            ivp:=
            piecewise([iv::dom::left(iv) < 0,
                       Dom::Interval([0], iv::dom::rightB(iv))],
                      [iv::dom::left(iv) >=0,
                       iv
                       ]
                      );

            ivn:=
            piecewise([iv::dom::right(iv) > 0,
                       Dom::Interval(iv::dom::leftB(iv), [0])],
                      [iv::dom::right(iv) <=0,
                       iv
                       ]
                      );

            // x^n in ivp iff abs(x)^n in ivp and n*arg(x)/PI is even
            // x^n in ivn iff abs(x)^n in -ivn and n*arg(x)/PI is odd
            
            // local methods preImageIVP, preImageIVN
            // given n, x, iv, these functions return the set of all
            // x with x^n in iv
            preImageIVP:=
            proc(n, x, iv, options)
              local ivroot, k;
            begin
              case domtype(iv)
                of piecewise do
                  return(piecewise::extmap
                         (iv, u -> preImageIVP(n, x, u, options))
                         )
                of DOM_SET do
                  return(solvelib::preImage(x^n, x, iv, options))
                of Dom::Interval do
                  ivroot:= Dom::Interval::mapBorders(iv, _power, 1/n);
                  return(solvelib::avoidAliasProblem
                         (_union(ivroot*exp(2*PI*I*k/n) $k=0..n-1),
                          {x})
                         )
              end_case;
              error("Unknown type of interval")
            end_proc;

            preImageIVN:=
            proc(n, x, iv, options)
              local ivroot, k;
            begin
              case domtype(iv)
                of piecewise do
                  return(piecewise::extmap
                         (iv, u -> preImageIVN(n, x, u, options))
                         )
                of DOM_SET do
                  return(solvelib::preImage(x^n, x, iv, options))
                of Dom::Interval do
                  ivroot:= Dom::Interval::mapBorders(-iv, _power, 1/n);
                  return(solvelib::avoidAliasProblem
                         (_union(ivroot*exp((2*k+1)*PI*I/n) $k=0..n-1),
                          {x})
                         )
              end_case;
              error("Unknown type of interval")
            end_proc;
          
            sol:= preImageIVP(expo, x, ivp, options) union
                  preImageIVN(expo, x, ivn, options);
            return(solvelib::preImage(base, x, sol, options))
            // type(expo) = DOM_INT
          of DOM_RAT do
            assert(expo > 0);
             //Let c>0. Then  x^b = c iff x= c^(1/b)*exp(2*PI*I*k/b)
            // with k integer, -b/2 < k <= b/2

            handleIV:=
            proc(iv)   // the left border of iv must be >=0
              local ivr;
            begin
              // with iv = (l, r), let ivr = (l^(1/b), r^(1/b))
              ivr:= iv^(1/expo);
              _union(ivr*exp(2*PI*I*k/expo)
                     $k=floor(-expo/2)+1 .. floor(expo/2))
            end_proc;
            
            // a fractional power can never be negative
            // thus we have to replace the left border of iv by
            // max(l, 0)
            return(solvelib::preImage(op(a, 1), x,
            piecewise([l<0, handleIV(IV([0], IV::rightB(iv) ))],
            [l>=0, handleIV(iv)]
            ),
            options
            ))
          end_case;
          if is(l>=0, Goal = TRUE) and is(expo > 0, Goal = TRUE) then
            // the function X -> X^expo is monotonic
            return(solvelib::preImage(op(a, 1), x, 
            Dom::Interval::mapBorders(iv, _power, 1/expo), options))
          end_if;  
            
      end_if;
      // inequalities with constant base, C^(f(x)) in iv
      //if not has(base, x) then

      //end_if;

      if is(op(a, 1) <>0 ) = TRUE then
        // rewrite by exp and fall through
        a:= hold(exp)(op(a, 2) * ln(op(a, 1)))
      else
        break
      end_if;
    of "exp" do
      if options[IgnoreAnalyticConstraints] or is(op(a, 1) in R_, Goal = TRUE) then
        sol:= piecewise([r<=0, {}],
                       [l<=0 and r>0, 
                        Dom::Interval(-infinity, mapB(rb, simplify@ln))
                         ],
                       [l>0, Dom::Interval(mapB(lb, simplify@ln),
                                                    mapB(rb, simplify@ln))
                        ]
                       )
      elif is(op(a, 1)/I in R_, Goal = TRUE) then
        // another special case: a= t*I, t in R_
        // exp(t*I) can take on the values -1 and 1 only
        sol:= iv intersect {-1, 1};
        if type(sol) = DOM_SET or type(sol) = piecewise then
          return(solvelib::preImage(a, x, sol, options))
        end_if
      else
        // exp(z) = C -> z = ln(C) + 2*k*PI*I for C<>0
        k:= genident();
        sol:= piecewise([l>0, IV::mapBorders(iv, ln) + 2*PI*I*Z_],
                        [l=0, IV(-infinity, mapB(IV::rightB(iv), ln))
                         + 2*PI*I*Z_],                                 
                        [r<0, IV::mapBorders(-iv, ln) +
                         Dom::ImageSet((2*k+1)*PI*I, k, Z_) ],
                        [r=0,  (IV(-infinity, mapB(IV::leftB(iv), ln@_negate))+
                          Dom::ImageSet((2*k+1)*PI*I, k, Z_))],
                        [l<0 and r>0,
                         (IV(-infinity, mapB(IV::leftB(iv), ln@_negate))+
                          Dom::ImageSet((2*k+1)*PI*I, k, Z_)) union
                         (IV(-infinity, mapB(IV::rightB(iv), ln)) + 2*PI*I*Z_)
                         ]
                        );
      end_if;
      return(solvelib::preImage(op(a, 1), x, sol, options))
    of "ln" do
      // ln(z) = a iff z = exp(a), we may just map exp to the borders
      return(solvelib::preImage(op(a, 1), x, Dom::Interval::mapBorders(iv, exp), options))
    of "sin" do
      if options[IgnoreAnalyticConstraints] then
        if is(l < -1, Goal = TRUE) then
          lb:= [-1]
        end_if;
        if is(r > 1, Goal = TRUE) then
          rb:= [1]
        end_if;
        iv:= Dom::Interval(lb, rb);
        if iv = {} then
          return({})
        end_if;
        return(solvelib::preImage(op(a, 1), x,
                                  Dom::Interval::mapBorders(iv, arcsin),
                                  options)
               )
      end_if;
      if not is(op(a, 1) in R_, Goal  = TRUE) then
        break
      end_if;
      k:= solvelib::getIdent(Z_);
      case [IV::isleftopen(iv), IV::isrightopen(iv)]
        of [TRUE, TRUE] do
          sol:=piecewise
                ([l < -1 and r > 1, R_],
                 [l >= -1 and r > 1,
                  solvelib::Union(IV(arcsin(l) + 2*k*PI,
                                     PI-arcsin(l) + 2*k*PI),
                                  k, Z_)],
                 [l < -1 and r <= 1,
                  solvelib::Union(IV(-arcsin(r)-PI + 2*k*PI,
                                     arcsin(r) + 2*k*PI),
                                  k, Z_)],
                 [l >= -1 and r <= 1,
                  solvelib::Union(IV(arcsin(l) + 2*k*PI,
                                     arcsin(r) + 2*k*PI),
                                  k, Z_) ],
                 [not l < r, {}]
                 );
          break
        of [TRUE, FALSE] do
          sol:=piecewise
                ([l < -1 and r >= 1, R_],
                 [l >= -1 and r >= 1,
                  solvelib::Union(IV(arcsin(l) + 2*k*PI,
                                     PI-arcsin(l) + 2*k*PI),
                                  k, Z_)],
                 [l < -1 and r < 1,
                  solvelib::Union(IV([-arcsin(r)-PI + 2*k*PI,
                                      arcsin(r) + 2*k*PI]),
                                  k, Z_)],
                 [l >= -1 and r < 1,
                  solvelib::Union(IV(arcsin(l) + 2*k*PI,
                                     [arcsin(r) + 2*k*PI]),
                                  k, Z_) ],
                 [not l < r, {}]
                 );
          break
        of [FALSE, TRUE] do
          sol:=piecewise
                ([l <= -1 and r > 1, R_],
                 [l > -1 and r > 1,
                  solvelib::Union(IV([arcsin(l) + 2*k*PI,
                                      PI-arcsin(l) + 2*k*PI]),
                                  k, Z_)],
                 [l <= -1 and r <= 1,
                  solvelib::Union(IV(-arcsin(r)-PI + 2*k*PI,
                                     arcsin(r) + 2*k*PI),
                                  k, Z_)],
                 [l > -1 and r <= 1,
                  solvelib::Union(IV([arcsin(l) + 2*k*PI],
                                     arcsin(r) + 2*k*PI),
                                  k, Z_) ],
                 [not l < r, {}]
                 );
          break
        of [FALSE, FALSE] do
          sol:=piecewise
                ([l <= -1 and r >= 1, R_],
                 [l > -1 and r >= 1,
                  solvelib::Union(IV([arcsin(l) + 2*k*PI,
                                      PI-arcsin(l) + 2*k*PI]),
                                  k, Z_)],
                 [l <= -1 and r < 1,
                  solvelib::Union(IV([-arcsin(r)-PI + 2*k*PI,
                                      arcsin(r) + 2*k*PI]),
                                  k, Z_)],
                 [l > -1 and r < 1,
                  solvelib::Union(IV([arcsin(l) + 2*k*PI,
                                      arcsin(r) + 2*k*PI]),
                                  k, Z_) ],
                 [not l <= r, {}]
                 );
          break
      end_case;
      return(solvelib::preImage(op(a, 1), x, sol, options))
      // end of type(a) = "sin"
    of "cos" do
      if options[IgnoreAnalyticConstraints] then
        if is(l < -1, Goal = TRUE) then
          lb:= [-1]
        end_if;
        if is(r > 1, Goal = TRUE) then
          rb:= [1]
        end_if;
        iv:= Dom::Interval(lb, rb);
        if iv = {} then
          return({})
        end_if;
        return(solvelib::preImage
               (op(a, 1), x,
                Dom::Interval::interchangeMapBorders(iv, arccos))
               )
      end_if;
      // handle via "sin"
      return(solvelib::preImage(sin(op(a, 1) + PI/2), x, iv, options))
    of "tan" do
      if options[IgnoreAnalyticConstraints] then
        return(solvelib::preImage(op(a, 1), x,
                                  Dom::Interval::mapBorders(iv, arctan),
                                  options)
               )
      end_if;
      break
    of "abs" do
      iv:= iv intersect Dom::Interval([0], infinity);
      X:= solvelib::getIdent(R_, indets(a));
      return(solvelib::preImage
             (op(a, 1), x, solvelib::Union
              (exp(X*I) * iv, X, Dom::Interval([0], 2*PI)), options)
             )
    of "arg" do
      if type(op(a, 1)) = "_power" and type((k:=op(a, [1, 2]))) = DOM_RAT then
        k:= abs(op(k, 2)); // denominator
        ivn:= iv intersect Dom::Interval(-PI/k, [PI/k]);
        if ivn = Dom::Interval(-PI/k, [PI/k]) then
          return(C_)
        end_if
      else
        ivn:= iv intersect Dom::Interval(-PI, [PI]);
        if ivn = Dom::Interval(-PI, [PI]) then
          return(C_)
        end_if
      end_if;
      if type(ivn) = "_intersect" then
        // give up in order to avoid an infinite recursion
        return(default())
      elif type(ivn) <> Dom::Interval then
        return(solvelib::preImage(a, x, ivn, options))
      else 
        iv:= ivn
      end_if;
      break
    of "Im" do
      if type(op(a, 1)) = "lambertW" then
        [k, z]:= [op(op(a, 1))];
        // a = Im(lambertW(k, z))
        // If l and r are odd multiples of PI,  
        // then the answer does not depend on z:
        // the imaginary part of the i-th branch of lambertW is between (2*i-1)*PI and (2*i+1)*PI
        if l = -infinity then nl:= l else nl:= (l/PI + 1)/2 end_if;
        if r = infinity then nr:= r else nr:= (r/PI - 1) /2 end_if; 
        if (nl = -infinity or type(nl) = DOM_INT) and
           (nr = infinity or type(nr) = DOM_INT) then
           return(solvelib::preImage(k, x, Dom::Interval([nl, nr]) intersect Z_, options))
        end_if   
      end_if;
      break
  end_case;

  // heuristics for "_plus", "_mult", "_power"
  if contains({"_plus", "_mult", "_power"}, type(a)) then
    inds:= select(indets(a, PolyExpr), has, x);
    if nops(inds) = 1 then
      // input is a polynomial in f(x) for some f
      // replace by new identifier if necessary
      if op(inds, 1) <> a then
        // op(inds, 1) = a would cause infinite recursion
        if op(inds, 1) <> x then
          X:= genident();
          sol:= subs(a, op(inds, 1) = X);
          assert(not has(sol, x));
          sol:= polyInIv(sol, X, iv, options);
          if type(sol) <> "solve" then
              return
              (
               solvelib::preImage(op(inds, 1), x, sol, options)
               )
          end_if
        else
          // op(inds, 1) = x
          // take care that x may also occur in the form x(0)
          if testtype(a, Type::PolyExpr([x])) then
            sol:= polyInIv(a, x, iv, options);
            if type(sol) <> "solve" then
              return(sol)
              // else: try intermediate-value theorem heuristic below
            end_if
          end_if
        end_if;
      end_if
    end_if;
  end_if;

  // rewrite heaviside 
  if hastype(a, "heaviside") then
    a:= rewrite(a, piecewise);
    return(solvelib::preImage(a, x, iv, options))
  end_if;

  MAXEFFORT:= MAXEFFORT/3;
  // try to find the preImage of R_ first; 
  preImageR:= solvelib::preImage(a, x, R_, options);

  if traperror((
  assume(x in preImageR, _and)
                )) <> 0 then
    // impossible assumption -> a cannot be real, hence the inequality
    // is not solvable
    return({})
  end_if;
  
  if IV::left(iv) = -infinity then
    sls:= solve(a = IV::right(iv), x, options)
  elif IV::right(iv) = infinity then
    sls:= solve(a = IV::left(iv), x, options)
  else        
    sls:= solve(a = IV::right(iv), x, options) union
          solve(a = IV::left(iv), x, options)
  end_if;

  sls:= sls union discont(a, x, Undefined, options);

  unassume(x);
  
  sol:= solvelib::handlePreImageR(preImageR, sls, a, x, iv, options);
  if not hastype(sol, "solve") then
    return(sol)
  end_if;
 

  // default
  default()
end_proc: