//   

/**************************************************
solvelib::preImageIntervalReal(ex, var, iv, options)

solves ex in iv for the variable var, in real mode
(that is, substituting a solution for var in ex gives
an expression every subexpression of which is real).
**************************************************/


alias(IV = Dom::Interval):
alias(SNDO = solvelib::nonDefaultOptions):

solvelib::preImageIntervalReal:=
proc(ex: Type::Arithmetical, var: DOM_IDENT, iv: Dom::Interval,
     options: DOM_TABLE )
  local l, r, lb, rb, f, dep, indep, dummy, num, dn, mapb, k, sol, base, expo,
  a, b, c, i, sls, preImageR,
  logbase: DOM_PROC,
  mysurdeven: DOM_PROC,
  mysurdodd: DOM_PROC;
  save MAXEFFORT;
begin
  assert(options[Real] = TRUE);
  
  mapb:=
  proc(b, f)
  begin
    if type(b) = DOM_LIST then
      [f(op(b, 1))]
    else
      f(b)
    end_if
  end_proc;


  if domtype(ex) = piecewise then
    return(
           solvelib::solve_union
           (
            solvelib::solve_intersect
            (
             solvelib::preImageIntervalReal
             (piecewise::expression(ex, i), var, iv, options),
             solve(piecewise::condition(ex, i), var, options)
             ) 
            $i=1..nops(ex)
            )
           )
  end_if;

  
  [l, r]:= Dom::Interval::borders(iv);
  [lb, rb]:= [op(iv)];
   // e.g. if iv = Dom::Interval([a], b) then
  // r = rb = b, l=a, lb = [a]
  
  assert(not has(iv, var));

  if l = -infinity and r = infinity then
    return(solvelib::preImageReal(ex, var, options))
  end_if;
  
  if not has(ex, var) then
    return(piecewise([ex in iv, R_], [not ex in iv, {}]))
  end_if;



  case type(ex)
    of DOM_IDENT do
      assert(ex = var);
      return(iv)      
    of "_mult" do
      [dep, indep, dummy]:= split(ex, has, var);
      assert(dummy = 1);
      if indep <> 1 then
        return(piecewise([indep = 0 and 0 in iv, R_],
                         [indep = 0 and not 0 in iv, {}],
                         [indep > 0,
                          solvelib::preImage
                          (dep, var, Dom::Interval::mapBorders
                           (iv, x -> if domtype(x) = stdlib::Infinity then
                                       x
                                     else
                                       x/indep
                                     end_if
                            ), options)],
                         [indep < 0,
                          solvelib::preImage
                          (dep, var, Dom::Interval
                           (if rb=infinity then
                              -infinity
                            else
                              mapb(rb, x -> x/indep)
                            end_if
                            ,
                            if lb=-infinity then
                              infinity
                            else
                              mapb(lb, x-> x/indep)
                            end_if
                              ), options)
                          ]
                         ))
      end_if;

      
      // split into numerator and denominator
      [dn, num, dummy]:= split(ex, fctor -> type(fctor) = "_power" and
                                stdlib::hasmsign(op(fctor, 2)) = TRUE);
      // wit den:= 1/dn, we want to solve num/den in [l, r]
      // this holds if l*den <= num <= r*den and den > 0
      // or r*den <= num <= l*den and den <= 0
      // or dn = 0 and 0 in iv
      if dn <> 1 then
        MAXEFFORT:= MAXEFFORT/5;
        sol:= 
        solvelib::solve_union
        (
         piecewise([0 in iv, solve(dn, var, options)],
                   [not 0 in iv, {}])
         ,
         solvelib::solve_intersect
         (
          if l=-infinity then
            R_
          elif type(lb) = DOM_LIST then
            solve(l/dn <= num, var, options)
          else
            solve(l/dn < num, var, options)
          end_if,
          if r= infinity then
            R_
          elif type(rb) = DOM_LIST then
            solve(num <= r/dn, var, options)
          else
            solve(num < r/dn, var, options)
          end_if,
          solve(1/dn > 0, var, options)
          )
         ,
         solvelib::solve_intersect
         (
          if l=-infinity then
            R_
          elif type(lb) = DOM_LIST then
            solve(l/dn >= num, var, options)
          else
            solve(l/dn > num, var, options)
          end_if,
          if r=infinity then
            R_
          elif type(rb) = DOM_LIST then
            solve(num >= r/dn, var, options)
          else
            solve(num > r/dn, var, options)
          end_if,
          solve(1/dn < 0, var, options)
          )
         )
        ;
        
        if not hastype(sol, "solve") then
          return(sol)
        end_if;                         
      end_if;
      case [lb, rb]
        of [0, infinity] do
          MAXEFFORT:= MAXEFFORT/3;
          // f_1 * .. * f_k > 0 iff an even number of factors is < 0 and no
          // factor is zero. It seems better to do this by recursion
          return
          (
           solvelib::solve_union
           (
           solvelib::solve_intersect
           (
            solvelib::preImageIntervalReal(op(ex, 1), var, iv, options),
            solvelib::preImageIntervalReal(subsop(ex, 1=1), var, iv, options)
            )
            ,
           solvelib::solve_intersect
           (
            solvelib::preImageIntervalReal(op(ex, 1), var, -iv, options),
            solvelib::preImageIntervalReal(subsop(ex, 1=1), var, -iv, options)
            )
           )
           )
        of [-infinity, 0] do
          MAXEFFORT:= MAXEFFORT/3;
          // as before, do this by recursion. f1*f2 < 0 iff
          // one factor is < 0 and the other is > 0
          return
          (
           solvelib::solve_union
           (
           solvelib::solve_intersect
           (
            solvelib::preImageIntervalReal(op(ex, 1), var, iv, options),
            solvelib::preImageIntervalReal(subsop(ex, 1=1), var, -iv, options)
            )
           ,
           solvelib::solve_intersect
           (
            solvelib::preImageIntervalReal(op(ex, 1), var, -iv, options),
            solvelib::preImageIntervalReal(subsop(ex, 1=1), var, iv, options)
            )
           )
           )
        of [[0], infinity] do
        of [-infinity,[0]] do
          MAXEFFORT:= MAXEFFORT/2;
          return
          (
           solvelib::solve_union
           (
           solvelib::preImageIntervalReal(ex, var, Dom::Interval::interior(iv),
                                          options)
            ,
            solve(ex, var, options)
            )
           )
      end_case;

      a:= combine(ex);
      a:= combine(a, sincos);
      if a <> ex then
        return(solvelib::preImageIntervalReal(a, var, iv, options))
      end_if;      
      break;
    of "_plus" do
      [dep, indep, dummy]:= split(ex, has, var);
      assert(dummy = 0);
      if indep <> 0 then
        return(solvelib::preImage(dep, var, iv -indep, options))
      end_if;
      // rewrite log to ln
      if hastype(ex, "log") then
        ex:= rewrite(ex, ln);
      end_if;
      
      ex:= normal(ex);
      if type(ex) <> "_plus" then
        return(solvelib::preImageIntervalReal(ex, var, iv, options))
      end_if;
      // combine a*ln(x) + b*ln(y) to ln(x^a * y^b)
      a:= match(ex, `#A`*ln(`#X`) + `#B`*ln(`#Y`) + `#C`,
                hold(Cond) = {`#A` -> not iszero(`#A`) and not has(`#A`, var),
                        `#B` -> not iszero(`#B`) and not has(`#B`, var)});
      if a <> FAIL and not bool(subs(`#X` = `#Y`, a)) then
        ex:= subs(ln(`#X`^`#A` * `#Y`^`#B`) + `#C`, a, EvalChanges);
        return(solvelib::preImageIntervalReal(ex, var, iv, options))
      end_if;
      if l=0 or r=0 and nops(ex) = 2 then
        c:= rewrite(ex, exp);
        c:= misc::maprec(c, {"_power"} =
                         proc(pow)
                         begin
                           if not contains({DOM_INT, DOM_RAT}, op(pow, 2))
                            and testtype(op(pow, 2), Type::Constant) 
                             then
                             exp(op(pow, 2) * ln(op(pow, 1)))
                           else
                             pow
                           end_if
                         end_proc
                         );
        c:= misc::maprec(c, {"ln"} =
                         proc(lnx)
                         begin
                           if type(op(lnx, 1)) = DOM_RAT then
                             ln(op(lnx, [1, 1])) - ln(op(lnx, [1, 2]))
                           else
                             lnx
                           end_if
                         end_proc
                         );
        // a*exp(x) + b*exp(y) < 0 iff
        // a*exp(x) < -b*exp(y) iff
        // a*exp(x-y) < -b
        // the same for <=, >, >0 instead of <
        a:= match(c, `#A`*exp(`#X`) + `#B`*exp(`#Y`),
                  hold(Cond) = {`#X` -> not iszero(`#X`),
                          `#Y` -> not iszero(`#Y`),
                          `#A` -> not has(`#A`, var),
                          `#B` -> not has(`#B`, var)}
                  );
        if a <> FAIL then
          return(
                 solvelib::preImageIntervalReal
                 (subs(`#A`*exp(`#X`-`#Y`) + `#B`, a),
                  var, iv, options)
                 )
        end_if;
      end_if;
      break
    of "_power" do
      [base, expo]:= [op(ex)];
      if contains({DOM_INT, DOM_RAT}, type(expo)) and expo < 0 then
        return(solvelib::preImage(1/ex, var, 1/iv, options))
      end_if;
      if type(expo) = DOM_INT and expo > 0 then
        if expo mod 2 = 1 then
          mysurdodd:= x -> if type(x) = stdlib::Infinity then
                             x
                           else
                             surd(x, expo)
                           end_if;
           return(solvelib::preImage
                  (base, var,
                   Dom::Interval::mapBorders(iv, mysurdodd),
                   options))
        end_if;
        // expo is even
        return(piecewise([r < 0, {}],
                         [r >= 0 and l<0,
                          solvelib::preImage
                          (base, var,
                          Dom::Interval( mapb(rb, x -> -x^(1/expo)),
                                         mapb(rb, x -> x^(1/expo))
                                        ),
                           options)
                          ],
                         [r>=0 and l>=0,
                          solvelib::preImage
                          (base, var,
                          Dom::Interval(mapb(lb, x-> x^(1/expo)),
                                        mapb(rb, x -> x^(1/expo))
                                        ),
                           options)
                          union
                          solvelib::preImage
                          (base, var,
                           Dom::Interval(mapb(rb, x -> -x^(1/expo)),
                                         mapb(lb, x -> -x^(1/expo))
                                         ),
                           options)
                          ]
                         ))
        
      end_if;
      if type(expo) = DOM_RAT and
        expo > 0 then
        // expo is a fraction
        mysurdeven:= x -> if type(x) = DOM_LIST then
                            [op(x)^(1/expo)]
                          else
                            x^(1/expo)
                          end_if;
        return(piecewise([r < 0, {}],
                         [r >= 0 and l < 0,
                          solvelib::preImage
                          (base, var,
                           Dom::Interval([0], mysurdeven(rb)),
                           options)
                           ],
                         [r >=0 and l>=0,
                          solvelib::preImage
                          (
                           base, var,
                           Dom::Interval(mysurdeven(lb), mysurdeven(rb)),
                           options)
                           ]
                         ))
      end_if;
      if not has(expo, var) then
        // x^(alpha) in iv iff alpha*ln(x) in ln(iv)
        return(
               piecewise([l>0, 
                          solvelib::preImage
                          (expo*ln(base), var,
                           Dom::Interval::mapBorders(iv, simplify@ln),
                           options)],
                         [l<=0 and r>0,
                          solvelib::preImage
                          (expo*ln(base), var,
                           Dom::Interval([0], mapb(rb, simplify@ln)),
                           options)
                          ],
                         [r<=0, {}]
                         )
               )
      end_if;
      if not has(base, var) then
        logbase := x -> if x=infinity then infinity else log(base, x) end;
        // a^x in iv
        // case 1: a=0: 0^0 is 1 and 0^x=1 for x>0
        // case 2: a>0: a^x = r if x = log(a, r) for positive r only
        // case 3: a<0: only integer powers of a are real;
        // to be consistent with eqsReal, we do not handle this at the moment
        return(piecewise
               (
                [base = 0 and 0 in iv and 1 in iv,
                 solvelib::preImageIntervalReal(expo, var,
                                                Dom::Interval([0], infinity),
                                                options)
                 ],
                [base = 0 and not 0 in iv and 1 in iv,
                 solve(expo, var, options)
                 ],
                [base = 0 and 0 in iv and not 1 in iv,
                  solvelib::preImageIntervalReal(expo, var,
                                                Dom::Interval(0, infinity),
                                                options)
                 ],
                [base = 0 and not 0 in iv and not 1 in iv
                 or base > 0 and r<=0,
                 {}
                 ],
                [base > 0 and l<=0,
                 solvelib::preImage
                 (expo, var,
                  Dom::Interval(-infinity, mapb(rb, logbase)),
                  options)
                 ],
                [base > 0 and l>0,
                 solvelib::preImage
                 (expo, var,
                  Dom::Interval(mapb(lb, logbase),
                                mapb(rb, logbase)),
                  options
                  )
                 ],
                [base < 0, 
                 freeze(solve)(ex in iv, var, SNDO(options))
                 ]
                ))
      end_if;
      break
    of "exp" do
      // exp(x) in [l, r] iff x in [max(0, ln(l)), ln(r)]
      return(piecewise([r<=0, {}],
                       [l<=0, solvelib::preImage
                        (op(ex), var,
                         Dom::Interval(-infinity, mapb(rb, simplify@ln)),
                         options)],
                       [l>0, solvelib::preImage
                        (op(ex), var, Dom::Interval(mapb(lb, simplify@ln),
                                                    mapb(rb, simplify@ln)),
                         options)
                        ]
                       ))
    of "log" do
      return(solvelib::preImageIntervalReal(rewrite(ex, ln), var, iv, options))
    of "ln" do
      // ln(x) in [a, b] iff x in [exp(a), exp(b)]
      return(solvelib::preImage(op(ex), var, exp(iv), options))
    of "sin" do
      if options[IgnoreAnalyticConstraints] then
        if is(l < -1, Goal = TRUE) then
          lb:= [-1]
        end_if;
        if is(r > 1, Goal = TRUE) then
          rb:= [1]
        end_if;
        iv:= Dom::Interval(lb, rb);
        return(solvelib::preImage(op(ex, 1), var,
                                  Dom::Interval::mapBorders(iv, arcsin),
                                  options)
               )
      end_if;
      k:= solvelib::getIdent(Z_);
      case [Dom::Interval::isleftopen(iv), Dom::Interval::isrightopen(iv)]
        of [TRUE, TRUE] do
          sol:=piecewise
                ([l < -1 and r > 1, R_],
                 [l >= -1 and l < 1 and r > 1,
                  solvelib::Union(Dom::Interval(arcsin(l) + 2*k*PI,
                                                PI-arcsin(l) + 2*k*PI),
                                  k, Z_)],
                 [l < -1 and r>-1 and r <= 1,
                  solvelib::Union(Dom::Interval(-arcsin(r)-PI + 2*k*PI,
                                                arcsin(r) + 2*k*PI),
                                  k, Z_)],
                 [l >= -1 and r <= 1,
                  solvelib::Union(Dom::Interval(arcsin(l) + 2*k*PI,
                                                arcsin(r) + 2*k*PI),
                                  k, Z_) ],
                 [not l < r or l>=1 or r<=-1, {}]
                 );
          break
        of [TRUE, FALSE] do
          sol:=piecewise
                ([l < -1 and r >= 1, R_],
                 [l >= -1 and l < 1 and r >= 1,
                  solvelib::Union(Dom::Interval(arcsin(l) + 2*k*PI,
                                                PI-arcsin(l) + 2*k*PI),
                                  k, Z_)],
                 [l < -1 and r < 1 and r>=-1,
                  solvelib::Union(Dom::Interval([-arcsin(r)-PI + 2*k*PI,
                                                 arcsin(r) + 2*k*PI]),
                                  k, Z_)],
                 [l >= -1 and r < 1,
                  solvelib::Union(Dom::Interval(arcsin(l) + 2*k*PI,
                                                [arcsin(r) + 2*k*PI]),
                                  k, Z_) ],
                 [not l < r or l>=1 or r<-1, {}]
                 );
          break
        of [FALSE, TRUE] do
          sol:=piecewise
                ([l <= -1 and r > 1, R_],
                 [l > -1 and l <=1 and r > 1,
                  solvelib::Union(Dom::Interval([arcsin(l) + 2*k*PI,
                                                 PI-arcsin(l) + 2*k*PI]),
                                  k, Z_)],
                 [l <= -1 and r <= 1 and r>-1,
                  solvelib::Union(Dom::Interval(-arcsin(r)-PI + 2*k*PI,
                                                arcsin(r) + 2*k*PI),
                                  k, Z_)],
                 [l > -1 and r <= 1,
                  solvelib::Union(Dom::Interval([arcsin(l) + 2*k*PI],
                                                arcsin(r) + 2*k*PI),
                                  k, Z_) ],
                 [not l < r or l>1 or r<=-1, {}]
                 );
          break
        of [FALSE, FALSE] do
          sol:=piecewise
                ([l <= -1 and r >= 1, R_],
                 [l > -1 and l <= 1 and r >= 1,
                  solvelib::Union(Dom::Interval([arcsin(l) + 2*k*PI,
                                                 PI-arcsin(l) + 2*k*PI]),
                                  k, Z_)],
                 [l <= -1 and r < 1 and r>=-1,
                  solvelib::Union(Dom::Interval([-arcsin(r)-PI + 2*k*PI,
                                                 arcsin(r) + 2*k*PI]),
                                  k, Z_)],
                 [l > -1 and r < 1,
                  solvelib::Union(Dom::Interval([arcsin(l) + 2*k*PI,
                                                 arcsin(r) + 2*k*PI]),
                                  k, Z_) ],
                 [not l <= r or l>1 or r<-1, {}]
                 );
          break
      end_case;
      return(solvelib::preImage(op(ex, 1), var, sol, options))
    of "cos" do
      if options[IgnoreAnalyticConstraints] then
        if is(l < -1, Goal = TRUE) then
          lb:= [-1]
        end_if;
        if is(r > 1, Goal = TRUE) then
          rb:= [1]
        end_if;
        iv:= Dom::Interval(lb, rb);
        return(solvelib::preImage
               (op(ex, 1), var,
                Dom::Interval::interchangeMapBorders(iv, arccos),
                options)
               )
      end_if;
      // cos(x) = sin(x + PI/2); we reduce this to the previous case
      return(solvelib::preImageIntervalReal
             (sin(op(ex, 1) + PI/2), var, iv, options)
             )
    of "tan" do
      if options[IgnoreAnalyticConstraints] then
        return(solvelib::preImage
               (op(ex, 1), var,
                Dom::Interval::mapBorders(iv, arctan),
                options)
               )
      end_if;
      // tan(x) in [l, r] iff x in k*PI + [arctan(l), arctan(r)] for
      // some k
      i:= solvelib::getIdent(Z_);
      return
      (solvelib::preImage
       (
        op(ex, 1), var,
        solvelib::Union(Dom::Interval::mapBorders(arctan(iv), _plus, i*PI),
                        i, Z_),
        options
        ))
    of "abs" do
      // abs(x) in [a, b] iff -b <= x <= -a or a <= x <= b
      // for nonnegative a, b
      return(piecewise([l >= 0, solvelib::preImage(op(ex), var, iv, options)
                        union solvelib::preImage(op(ex), var, -iv, options)
                        ],
                       [l < 0, solvelib::preImage
                        (op(ex), var, Dom::Interval([0], rb), options)
                        union
                        solvelib::preImage
                        (op(ex), var, -Dom::Interval([0], rb), options)
                        ]
                       ))
  end_case;


  // other polynomials not covered yet:
  if testtype(ex, Type::PolyExpr([var])) then
    f:= poly(ex, [var]);
    if degree(f) = 1 then
      [b, a]:= [coeff(f, i) $i=0..1];
      return(solvelib::preImageIntervalReal
             (a*var, var,
              Dom::Interval::mapBorders(iv, _subtract, b ),
              options))
    end_if;
    if degree(f) = 2 then
      // f = a*x^2 + b*x + c
      // we write this as a*( x + b/2/a)^2 + (c-b^2/4/a)
      [c, b, a]:= [coeff(f, i) $i=0..2];
      return(piecewise([a = 0, solvelib::preImageIntervalReal
                        (b*var, var,
                         Dom::Interval::mapBorders(iv, _subtract, c),
                         options)],
                       [a <> 0,solvelib::preImageIntervalReal
                        (a*(var + b/2/a)^2, var,
                         Dom::Interval::mapBorders(iv, _subtract, c-b^2/4/a),
                        options)
                        ]
                       ))
    end_if;
  end_if;


  if hastype(ex, {"abs", "sign"}) then
    ex:= subs(ex,
              hold(abs) = (x -> piecewise([x<=0, -x], [x>=0, x])),
              hold(sign) = (x -> piecewise([x=0, 0], [x>0, 1], [x<0, -1])),
              EvalChanges);
    return(solvelib::preImage(ex, var, iv, options))
  end_if;
  
  
  if (a:= normal(ex)) <> ex then
    return(solvelib::preImageIntervalReal(a, var, iv, options))
  end_if;

  // try to factor
  if l = -infinity then
    // solve ex < r, i.e, ex -r < 0
    a:= factor(ex -r);
    if nops(a) > 3 then
      a:= expr(a);
      return(solvelib::preImageIntervalReal(a, var, iv-r, options))
    end_if;
  end_if;
  if r = infinity then
    a:= maprat(ex -l, factor);
    if nops(a) > 3 then
      a:= expr(a);
      return(solvelib::preImageIntervalReal(a, var, iv-l, options))
    end_if;
  end_if;

  // try to rationalize
  // this will help e.g. if ex = x^(1/2) + x^(1/3)
  [a, c]:= [rationalize(ex, FindRelations =  ["sin", "_power"])];
  // now ex = subs(a, c) 
  // if c = {X = f(var)}, then we solve a in iv for X and then f(var)=X for var
  if not has(a, var) and domtype(a) <> DOM_IDENT and nops(c) = 1 then
    sol:= solvelib::preImageIntervalReal(a, op(c, [1, 1]), iv, options);
    if not hastype(sol, "solve") then
      return
      (
       solvelib::preImage(op(c, [1, 2]), var, sol, options)
       )
    end_if;
  end_if;


  
  
  // use the intermediate value theorem

  // try to find the preImage of R_ first;
  MAXEFFORT:= MAXEFFORT/2;
  preImageR:= solvelib::preImage(ex, var, R_, options);

  save var;
  if traperror((
  assume(var in preImageR, _and)
                )) <> 0 then
    // impossible assumption -> a cannot be real, hence the inequality
    // is not solvable
    return({})
  end_if;
  if IV::left(iv) = -infinity then
    sls:= solve(ex = IV::right(iv), var, options)
  elif IV::right(iv) = infinity then
    sls:= solve(ex = IV::left(iv), var, options)
  else        
    sls:= solve(ex = IV::right(iv), var, options) union
          solve(ex = IV::left(iv), var, options)
  end_if;

  sls:= sls union discont(ex, var, Undefined);
  
  sol:= solvelib::handlePreImageR(preImageR, sls, ex, var, iv, options);
  if not hastype(sol, "solve") then
    return(sol)
  end_if;

  
  solvelib::preImageIntervalRealDefault(ex, var, iv, options)
  
end_proc:


solvelib::preImageIntervalRealDefault:=
proc(ex, var, iv, options)
  local l, r;
begin
  [l, r]:= Dom::Interval::borders(iv);
  if l = -infinity then
    if Dom::Interval::isrightopen(iv) then
      hold(solve)(ex < r, var, SNDO(options))
    else  
      hold(solve)(ex <= r, var, SNDO(options))
    end_if
  elif r = infinity then
    if Dom::Interval::isleftopen(iv) then
      hold(solve)(ex > l, var, SNDO(options))
    else  
      hold(solve)(ex >= l, var, SNDO(options))
    end_if
  else
    hold(solve)(ex in iv, var, SNDO(options))
  end_if
end_proc:


solvelib::preImageIntervalReal:= prog::remember
(solvelib::preImageIntervalReal,
() -> property::depends([args(1..3)]),
PreventRecursion,
solvelib::preImageIntervalRealDefault
):


unalias(IV):
unalias(SNDO):
