
alias(CONSTANTS = [0, 1, PI, exp(1)]):

solvelib::principalValue:=
proc(eqs, vars, options: DOM_TABLE)
  local result, c, sol;
begin

  if not contains({DOM_LIST, DOM_SET}, type(eqs)) and
    type(vars) = DOM_IDENT then
    for c in CONSTANTS do
      if traperror((sol:= testeq((eqs | vars=c), 0))) = 0 and sol = TRUE then
        return({c})
      end_if
    end_for
  end_if;

  options[PrincipalValue]:=FALSE;
  sol:= solve(eqs, vars, options);
  if sol = {} then
    return({})
  elif type(sol) = "_in" then 
    result:= solvelib::getElement(op(sol, 2))
  else
    result:= solvelib::getElement(sol)
  end_if;
  if result = FAIL then
    options[PrincipalValue]:= TRUE;
    if type(sol) <> "solve" then
      warning("Equation has been solved, but no element could be extracted")
    end_if;
    hold(solve)(eqs, vars, solvelib::nonDefaultOptions(options))
  elif type(sol) = "_in" then 
    if options[VectorFormat] then 
      op(sol, 1) in {result}
    else 
      solvelib::convertToAssignments({result}, [op(op(sol, 1))])
    end_if  
  else
    {result}
  end_if

end_proc:
// end of file
